% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_word_lists.R
\name{make.list.table}
\alias{make.list.table}
\title{Collate multiple regression runs.}
\usage{
make.list.table(result.list, model.names = names(result.list), M = 100,
  topic = "Summary Collection", method = c("rank", "weight", "count",
  "word"), annotate = TRUE)
}
\arguments{
\item{result.list}{List of mix of textreg.result objects and dataframes with two columns of
"word" and "weight".  (The latter is for merging lists from other regression packages.)}

\item{model.names}{Names of the textreg.result objects}

\item{M}{maximum number of words to keep}

\item{topic}{String A name for the topic}

\item{method}{Different ways to sort the phrases.  'word' means make a list of words.}

\item{annotate}{Add summary statistics to table such as phrase counts, etc.}
}
\value{
If annotate = true, a dataframe with each column corresponding to an textreg.result 
  object (and possibly extra columns about phrases).  Otherwise a matrix of the word scores.
}
\description{
This method makes a table of several regression runs side by side.
The table has rows being phrases and the
columns being the regression runs.  A number is usually the 
weight found for that word at that window.
If multiple runs have the same phrase, row will
have multiple entries.
}
\details{
Method will also order rows based on calculated importance of phrases.
Multiple ways of ordering are possible, via the \code{method} argument.

Finally, the table can be annotated with descriptive statistics of the phrases.

Warning: this method DOES NOT flip negative weight words (so negative weight usually look
less imporant in the ordering).

See the bathtub vignette for an example of this method.
}
