% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textBoxPlacement.R
\name{stagger}
\alias{stagger}
\title{stagger}
\usage{
stagger(xList, yList, tList, sortB = FALSE, verbose)
}
\arguments{
\item{xList}{list whose components are numeric vectors of the x values for overlaid curves}

\item{yList}{list whose components are numeric vectors of the y values for overlaid curves}

\item{tList}{list of character string texts to insert in plot}

\item{sortB}{Boolean if TRUE staggered curves reordered, with
largest range curve on bottom of graph}

\item{verbose}{Boolean if TRUE print informative or diagnostic messages to console}
}
\value{
returns a list whose components are:
\itemize{
\item textBoxHeights return value of textBoxUserUnits()
\item permInd return value of permInd()
\item xlim numeric vector parameter for plot()
\item ylim numeric vector parameter for plot()
}
}
\description{
unclutter the overlay plot by staggering the graphs
}
\details{
In order to unclutter the overlay plot, we need to stagger the graphs
the offset for each graph will be the sum of the max values for all
of the preceding graphs.
So the stack of staggered graphs will have max y (ie, ymax) equal to
the sum of the max's.
}
\examples{
# demonstrate effect of sorting the curves

plot.new()

stagger(xList2,yList2,textList,sortB=FALSE,verbose=TRUE)

stagger(xList2,yList2,textList,sortB=TRUE,verbose=TRUE)

}
