% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textBoxPlacement.R
\name{positionTextBoxDriverDriver}
\alias{positionTextBoxDriverDriver}
\title{positionTextBoxDriverDriver}
\usage{
positionTextBoxDriverDriver(
  xList,
  yList,
  textList,
  xPos,
  nApprox = 10,
  labs,
  stag = FALSE,
  offset = 0,
  ystart,
  ylim,
  verbose
)
}
\arguments{
\item{xList}{list whose components are numeric vectors of the x values for overlaid curves}

\item{yList}{list whose components are numeric vectors of the y values for overlaid curves}

\item{textList}{list of character string texts to insert in plot}

\item{xPos}{numeric vector x position for text box}

\item{nApprox}{integer number of intervals to interpolate between x data points}

\item{labs}{list of labels annotating a graph
\itemize{
\item main character string main title
\item xlab character string x axis label
\item ylab character string y axis label
}}

\item{stag}{Boolean TRUE if this plot has staggering added to curves}

\item{offset}{numeric vector of offsets added to each curve}

\item{ystart}{numeric vector of starting positions}

\item{ylim}{numeric vector ylim parameter for plot()}

\item{verbose}{Boolean if TRUE print informative or diagnostic messages to console}
}
\value{
returns a vector of integers indicating curves whose
text box could not be drawn
}
\description{
Driver to compute x and y coordinates for placement of text box
based upon the y values of the function
to avoid running into the graph line
and avoid overlapping with other overlay curves
}
\details{
if the length of the return value is not 0,
then additional processing might be needed for the
bad curves, such as adding an offset to their y values,
plotting them in a different color or symbol,
and keying them to a second y axis on the right of the graph
}
\examples{
# the text box for the second curve cannot fit,
# as it is sandwiched between two curves that are too close

plot(xList1[[1]],yList1[[1]],type="l")
positionTextBoxDriverDriver(xList=xList1,yList=yList1,
  textList=textList,xPos=c(1,1,1),nApprox=10,labs=labs,
  stag=FALSE,offset=0,ystart=0,ylim=axesRange(yList1),verbose=TRUE)

}
