% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_tfidf.R
\docType{data}
\name{TfIdf}
\alias{TfIdf}
\title{TfIdf}
\format{\code{\link{R6Class}} object.}
\usage{
TfIdf
}
\description{
Creates TfIdf(Latent semantic analysis) model.
"smooth" IDF (default) is defined as follows: \code{idf = log(1 + (# documents in the corpus) / (# documents where the term appears) )}
"non-smooth" IDF is defined as follows: \code{idf = log((# documents in the corpus) / (# documents where the term appears) )}
}
\details{
Term Frequency Inverse Document Frequency
}
\section{Usage}{

For usage details see \bold{Methods, Arguments and Examples} sections.
\preformatted{
tfidf = TfIdf$new(smooth_idf = TRUE, norm = c('l1', 'l2', 'none'), sublinear_tf = FALSE)
tfidf$fit_transform(x)
tfidf$transform(x)
}
}

\section{Methods}{

\describe{
  \item{\code{$new(smooth_idf = TRUE, norm = c("l1", "l2", "none"), sublinear_tf = FALSE)}}{Creates tf-idf model}
  \item{\code{$fit_transform(x)}}{fit model to an input sparse matrix (preferably in "dgCMatrix"
   format) and then transforms it.}
  \item{\code{$transform(x)}}{transform new data \code{x} using tf-idf from train data}
}
}

\section{Arguments}{

\describe{
 \item{tfidf}{A \code{TfIdf} object}
 \item{x}{An input term-co-occurence matrix. Preferably in \code{dgCMatrix} format}
 \item{smooth_idf}{\code{TRUE} smooth IDF weights by adding one to document
  frequencies, as if an extra document was seen containing every term in the
  collection exactly once.}
 \item{norm}{\code{c("l1", "l2", "none")} Type of normalization to apply to term vectors.
  \code{"l1"} by default, i.e., scale by the number of words in the document. }
 \item{sublinear_tf}{\code{FALSE} Apply sublinear term-frequency scaling, i.e.,
 replace the term frequency with \code{1 + log(TF)}}
}
}

\examples{
data("movie_review")
N = 100
tokens = word_tokenizer(tolower(movie_review$review[1:N]))
dtm = create_dtm(itoken(tokens), hash_vectorizer())
model_tfidf = TfIdf$new()
dtm_tfidf = model_tfidf$fit_transform(dtm)
}
\keyword{datasets}
