% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figure-tools.R
\name{patch_figure_env}
\alias{patch_figure_env}
\title{patch figure environments}
\usage{
patch_figure_env(article_dir, with_alg = TRUE)
}
\arguments{
\item{article_dir}{path to the directory which contains tex article}

\item{with_alg}{to include algorihtm environment or not}
}
\value{
patches figure environments in LaTeX file and also backs up the old file before modification
}
\description{
This function calls the stream editor to change
figure* to figure
1. figure*
}
\examples{
article_dir <- system.file("examples/article",
                 package = "texor")
dir.create(your_article_folder <- file.path(tempdir(), "tempdir"))
x <- file.copy(from = article_dir, to = your_article_folder,recursive = TRUE,)
your_article_path <- paste(your_article_folder,"article",sep="/")
texor::patch_figure_env(your_article_path)
unlink(your_article_folder,recursive = TRUE)
}
