% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_arguments.R
\name{optimal_arguments}
\alias{optimal_arguments}
\title{Find the optimal combinations of arguments for each diagnostic}
\usage{
optimal_arguments(object, optimality_criterion = which.min)
}
\arguments{
\item{object}{an object of class \code{'testargs'}}

\item{optimality_criterion}{a function (or list of functions) that defines the optimality criterion for each diagnostic.
Each function should return a single positive integer indicating the index of the optimal argument combination.
If a named list is provided with less elements than the number of diagnostic scores, unspecified diagnostics are assumed to be negatively oriented (i.e., assigned optimality criterion \code{which.min})}
}
\value{
A \code{data.frame}; each row corresponds to one of the diagnostics (specified by the row names), and the columns contain the argument values that optimise the corresponding diagnostic. The diagnostics at each of these optimal argument combinations are also included
}
\description{
The measure of optimality is typically diagnostic dependent; for example,
we wish to minimise the RMSE and run time, but we want coverage
to be as close to the purported value as possible. Hence,
\code{optimal_arguments()} allows one to set the optimality criteria individually for each diagnostic.
}
\examples{
## See ?test_arguments
}
