% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_functions.R
\name{format_extreme_values_ci}
\alias{format_extreme_values_ci}
\title{Format extreme values part of a confidence interval}
\usage{
format_extreme_values_ci(digits = 2L)
}
\arguments{
\item{digits}{(\code{integer(1)})\cr number of decimal places to display.}
}
\value{
An \code{rtables} formatting function that uses threshold \code{digits} to return a formatted extreme
values confidence interval.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Formatting Function for extreme values part of a confidence interval. Values
are formatted as e.g. "(xx.xx, xx.xx)" if the number of \code{digits} is 2.
}
\examples{
format_fun <- format_extreme_values_ci(2L)
format_fun(x = c(0.127, Inf))
format_fun(x = c(0, 0.009))

}
\seealso{
Other formatting functions: 
\code{\link{extreme_format}},
\code{\link{format_auto}()},
\code{\link{format_count_fraction}()},
\code{\link{format_count_fraction_fixed_dp}()},
\code{\link{format_count_fraction_lt10}()},
\code{\link{format_extreme_values}()},
\code{\link{format_fraction}()},
\code{\link{format_fraction_fixed_dp}()},
\code{\link{format_fraction_threshold}()},
\code{\link{format_sigfig}()},
\code{\link{format_xx}()},
\code{\link{formatting_functions}}
}
\concept{formatting functions}
