% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute.R
\name{tune_theta}
\alias{tune_theta}
\title{Estimate the penalty parameter for Step 2 of Virtual Twins}
\usage{
tune_theta(
  data,
  Trt,
  Y,
  zbar,
  step1,
  step2,
  threshold,
  alpha0,
  p_reps,
  parallel,
  ...
)
}
\arguments{
\item{data}{a data frame containing a response, binary treatment indicators,
and covariates.}

\item{Trt}{a string specifying the name of the column of \code{data}
contains the treatment indicators.}

\item{Y}{a string specifying the name of the column of \code{data}
contains the response.}

\item{zbar}{the estimated marginal treatment effect}

\item{step1}{character strings specifying the Step 1 model. Supports
either "\code{lasso}", "\code{mars}", "\code{randomforest}", or
"\code{superlearner}".}

\item{step2}{a character string specifying the Step 2 model. Supports
"\code{lasso}", "\code{rtree}",  "\code{classtree}", or "\code{ctree}".}

\item{threshold}{for "\code{step2 = 'classtree'}" only. The value against
which to test if the estimated individual treatment effect from Step 1 is
higher (TRUE) or lower (FALSE).}

\item{alpha0}{the nominal Type I error rate.}

\item{p_reps}{the number of permutations to run.}

\item{parallel}{Should the loop over replications be parallelized? If
\code{FALSE}, then no, if \code{TRUE}, then yes.
Note that running in parallel requires a \emph{parallel backend} that must be
registered before performing the computation.
See the \code{\link[foreach]{foreach}} documentation for more details.}

\item{...}{additional arguments to the Step 1 model call.}
}
\value{
the estimated penalty parameter
}
\description{
Permutes data under the null hypothesis of a constant treatment effect and
calculates the MNPP on each permuted data set. The \code{1 - alpha} quantile
of the distribution is taken.
}
