% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sace.R
\name{sace}
\alias{sace}
\title{Estimation of causal effects with outcomes truncated by death}
\usage{
sace(Z, S, Y, X, A, subset, optim.method = "BFGS", max.step = 1000,
  singular.ok = TRUE, need.variance = TRUE, hessian = TRUE)
}
\arguments{
\item{Z}{a logical vector. Exposure indicator. Convetionally, \code{1} means treatment and \code{0} means control. Must not have missing values.}

\item{S}{a logical vector. Survival indicator. \code{1} means survival and \code{0} means death. Must not have missing values.}

\item{Y}{a numeric vector. (Univariate) outcomes. May have \code{NA} where \eqn{S=0} (since \eqn{Y} is not well-defined where \eqn{S=0}).}

\item{X}{an optional numeric matrix or vector. Baseline covariates.}

\item{A}{an optional numeric matrix or vector. Substitution variable(s) which satisfies the assumptions of "exclusion restriction" and "substitution relevance". See references. If \code{A == NULL}, then the naive method, namely OLS, will be used.}

\item{subset}{an optional vector specifying a subset of obervations to be used.}

\item{optim.method}{The method to be used for maximum likelihood optimization. See \link[stats]{optim}.}

\item{max.step}{integer. Maximum iterating steps of maximum likelihood optimization.}

\item{singular.ok}{logical. Refers to the OLS estimation of the coefficients \code{alpha_1} and \code{alpha_2} using \link[stats]{lm}. If \code{FALSE} (default), a singular fit raises an error.}

\item{need.variance}{logical. Is variance of parameters and estimators needed? See details.}

\item{hessian}{logical. If \code{TRUE}, the hessian returned by \link[stats]{optim} will be used to compute the information matrix. If \code{FALSE}, the matrix will be calculated by an explicit formula.}
}
\value{
a list with following elements:
\item{CALL}{function call.}
\item{data}{data used (within the specified subset).}
\item{optim.method}{method used for optimization.}
\item{need.variance}{is variance of parameters and estimators needed?}
\item{n}{sample size.}
\item{mu_0_LL}{average potential outcomes among control group, \eqn{E[ Y(0) | G=LL ]}.}
\item{mu_1_LL}{average potential outcomes among treatment group, \eqn{E[ Y(1) | G=LL ]}.}
\item{sace}{survivor average causal effect, equals \code{mu_1_LL}-\code{mu_0_LL}.}
\item{beta}{\eqn{Pr{S(1)=1| X,A}=expit(\beta_0+X' \beta_1+ A \beta_2)}, estimated by MLE.}
\item{gamma}{\eqn{Pr{S(0)=1| X,A}/Pr{S(1)=1| X,A}=expit(\gamma_0+X' \gamma_1+ A \gamma_2)}, estimated by MLE.}
\item{beta_gamma.convergence}{indicator of convergence of MLE optimization of beta and gamma. 0 means convergence. See \link[stats]{optim}.}
\item{alpha_1}{\eqn{E[Y(0)| Z=0, G=LL, X, A ]=\alpha_{10}+X' \alpha_{11}+ A \alpha_{12}}, coefficients of \code{lm(Y ~ 1 + X + A, subset = Z == 0)}.}
\item{alpha_2}{\eqn{E[Y(1)| Z=1, G=LL, X, A ]=\alpha_{20}+X' \alpha_{21}+ G \alpha_{22}}, coefficients of \code{lm(Y ~ 1 + X + W.expit, subset = (Z == 1 & S == 1))}.}
The following items will be given only if \code{need.variance == TRUE}:
\item{beta.var}{estimated asymptotic covariance matrix of beta.}
\item{gamma.var}{estimated asymptotic covariance matrix of gamma.}
\item{relevance.Pvalue}{P value of the asymptotic chi-squared test on the relevance assumption for the substitution variable. A large P value suggests that the relevance assumption may not hold, namely, the substitution variable(s) may have little impact on the latent survival type.}
\item{alpha_1.var}{estimated asymptotic covariance matrix of alpha_1.}
\item{alpha_2.var}{estimated asymptotic covariance matrix of alpha_2.}
\item{mu_0_LL.var}{estimated asymptotic variance of mu_0_LL.}
\item{mu_1_LL.var}{estimated asymptotic variance of mu_1_LL.}
\item{sace.var}{estimated asymptotic variance of the SACE.}
}
\description{
\code{sace} estimates survivor average causal effects (SACE) with outcomes truncated by death.
}
\details{
This function \code{sace}, gives estimation of average causal effects (ACE) with outcomes truncated by death. The identification of SACE relies on the existence of a substitution variable and requires the assumptions of monotonicity, ignorability, exclusion restriction, and relevance. While the naive estimates given by the coefficient of \code{Z} from \code{lm(Y ~ Z + X + A, subset = S == 1)} are restricted among survivors and therefore may be subject to selection bias, this method gives consistent estimates of the SACE (survivor average causal effect), defined as the average causal effect among the subgroup consisting of subjects who would survive under either exposure, i.e. among the always-survivor group (\eqn{G=LL}). See references for details of the assumptions and the model parameterizations.

Parameters \code{beta} and \code{gamma} are estimated by MLE, using \link[stats]{optim}.

If \code{need.variance == TRUE}, the asymptotic variance estimators of both parameters and estimators will be given. This requires the \pkg{numDeriv} package.
}
\note{
The length of vectors \code{Z}, \code{Y}, \code{S}, as well as the row number of matrix \code{X} and \code{A} must equal the sample size \code{n}.
}
\examples{
attach(simulated_data)
X <- cbind(X.X1, X.V2, X.V3)
sace.result <- sace(Z, S, Y, X, A)
sace
}
\author{
Linbo Wang <linbo.wang@utoronto.ca>

Zhixuan Shao <shaozhixuansh@pku.edu.cn>
}
\references{
Linbo Wang, Xiao-Hua Zhou, Thomas S. Richardson; Identification and estimation of causal effects with outcomes truncated by death, Biometrika, Volume 104, Issue 3, 1 September 2017, Pages 597-612, \url{https://doi.org/10.1093/biomet/asx034}
}

