% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tn_an.R
\name{tn_an}
\alias{tn_an}
\alias{tn_fn}
\alias{tn_fna}
\alias{tn_fnas}
\alias{tn_ana}
\title{Standard formats for accepted names}
\usage{
tn_fn(x, ...)

tn_fna(x, ...)

tn_fnas(x, ...)

tn_an(x, ...)

tn_ana(x, ...)
}
\arguments{
\item{x}{A vector containing selected identifiers for taxon concepts
(\strong{TaxonConceptID}) included in the internal taxonomic object
(see \code{\link[=set_tax]{set_tax()}}).}

\item{...}{Further arguments passed to \code{\link[taxlist:print_name]{taxlist::print_name()}}.}
}
\value{
All these functions return a character value.
}
\description{
Inserting formatted taxonomic names in documents require specific functions
for every format, which are provided here.

These functions print only accepted names for the selected taxon concepts.

Suffixes in the function names are explained as follows:
\itemize{
\item \strong{fn:} Full name without author name.
\item \strong{fna:} Full name with author name.
\item \strong{fnas:} Full name with author name and taxon view (secundum).
\item \strong{an:} Abbreviated name without author name.
\item \strong{ana:} Abbreviated name with author name.
}
}
\examples{
## Compare all these outputs
tn_fn(13)
tn_fna(13)
tn_fnas(13)
tn_an(13)
tn_ana(13)
}
