% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_names.R
\name{match_names}
\alias{match_names}
\alias{match_names,character,character-method}
\alias{match_names,character,missing-method}
\alias{match_names,character,taxlist-method}
\title{Search matchings between character and taxlist objects}
\usage{
match_names(x, object, ...)

\S4method{match_names}{character,character}(
  x,
  object,
  UsageID,
  best = 1,
  nomatch = TRUE,
  method = "lcs",
  cutlevel = NULL,
  ...
)

\S4method{match_names}{character,missing}(x, best, cutlevel, nomatch = TRUE, ...)

\S4method{match_names}{character,taxlist}(
  x,
  object,
  show_concepts = FALSE,
  accepted_only = FALSE,
  include_author = FALSE,
  ...
)
}
\arguments{
\item{x}{A character vector with names to be compared.}

\item{object}{Either a character vector or a \linkS4class{taxlist} object
containing the taxonomic list for comparison. If missing, the similarity
of each name in 'x' will be compared with the rest of the names in the
same vector.}

\item{...}{Further arguments passed among methods.}

\item{UsageID}{A vector with IDs for single usage names in the compared list.
If the IDs are duplicated or not as much as names in 'object', the
function retrieves an error message. If missing, this function will
number every name anew (see column 'TaxonUsageID' in the output object).}

\item{best}{Integer value indicating how many matches should be displayed
in the output. Matches with the same value of similarity will be
considered as one. Note that this argument will be overrode by
'cutlevel'.}

\item{nomatch}{A logical value indicating wheter names without matches should
be included in the output (\code{'nomatch = TRUE'}) or not
(\code{'nomatch = FALSE'}).}

\item{method}{Further arguments passed to \code{\link[stringdist:stringsim]{stringdist::stringsim()}}.}

\item{cutlevel}{A numeric value indicating a cut level of similarity,
considering as match names with similarities equal or bigger than the
cut value. This argument overrides 'best'.}

\item{show_concepts}{Logical value indicating whether the respective taxon
concepts should be displayed in output or not.}

\item{accepted_only}{Logical value indicating whether only accepted names
should be matched or all usage names (including synonyms).}

\item{include_author}{A logical value indicating whether the author name
in object (method for \linkS4class{taxlist}) should be included in the matching
list or not.}
}
\description{
Names provided in a character vector will be compared with names stored in
slot \code{taxonNames} within an object of class \linkS4class{taxlist} by
using the function \code{\link[stringdist:stringsim]{stringdist::stringsim()}}.
}
\examples{
## Names to be compared
species <- c("Cyperus papyrus", "Typha australis", "Luke Skywalker")

## Comparing character vectors
match_names(c("Cyperus paper", "TIE fighter"), species)

## Retrieve taxon usage names
match_names(species, Easplist)

## Display accepted names in output
match_names(x = species, object = Easplist, show_concepts = TRUE)

# Using cut value for similarity
match_names(x = species, object = Easplist, cutlevel = 0.8)
}
\seealso{
\code{\link[stringdist:stringsim]{stringdist::stringsim()}}
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
