% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_taxa.R
\name{merge_taxa}
\alias{merge_taxa}
\alias{merge_taxa.taxlist}
\alias{merge_taxa,taxlist-method}
\title{Merge concepts or move names}
\usage{
merge_taxa(object, ...)

\method{merge_taxa}{taxlist}(
  object,
  concepts,
  level = NULL,
  delete_nomatch = FALSE,
  print_output = FALSE,
  ...
)
}
\arguments{
\item{object, taxlist}{Object of class \linkS4class{taxlist}.}

\item{...}{Further arguments to be passed to or from other methods.}

\item{concepts}{Numeric (integer) vector including taxon concepts to be
merged.}

\item{level}{Character vector with queried taxonomic ranks. This setting
works only if \code{concepts} are missing. ranks in between will be merged to
their respective parents by \code{\link[=merge_to_parent]{merge_to_parent()}}. Non queried ranks as
well as rankless concepts will be deleted from the output.}

\item{delete_nomatch}{A logical value indicating whether no matched ranks
(i.e. top rank and rankless concepts) should be deleted from the output
or not.}

\item{print_output}{Logical value indicating whether the merged concept
should be displayed in the console. Thi works only if a vector is
provided at \code{concepts}.}
}
\value{
An object of class \linkS4class{taxlist}.
}
\description{
Merge taxon concepts form a \linkS4class{taxlist} object into single ones.
}
\details{
Taxon concepts indicated in argument \code{concepts} will be merged into a
single concept.
The new concept inherits the ID and respective attributes from slots
\code{taxonRelations} and \code{taxonTraits} from the first taxon concept
indicated in argument \code{concepts}.

For convenience the resulting concept can be displayed by setting
\code{print_output=TRUE} but only when using argument \code{concepts}.

An alternative application of this function is implemented through the
argument \code{level}, where all lower rank taxa will be merged to the indicated
level or higher (if parent of merged taxa are at a higher rank).
}
\examples{
## Merge Cyperus papyrus and Cyperus dives
summary(Easplist, c(206, 197))

merged_cyperus <- merge_taxa(object = Easplist, concepts = c(206, 197),
    print_output = TRUE)

## Subset with Kyllinga species
ky <- subset(Easplist, TaxonName == "Kyllinga", keep_children = TRUE,
    keep_parents = TRUE)
ky
indented_list(ky)

## Merge to species and family
merge_taxa(ky, level = c("species", "family"))

## Merge to variety and genus
merge_taxa(ky, level = c("variety", "genus"))
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
