% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/td_create.R
\name{td_create}
\alias{td_create}
\title{create a local taxonomic database}
\usage{
td_create(
  provider = getOption("taxadb_default_provider", "itis"),
  schema = c("dwc", "common"),
  version = latest_version(),
  overwrite = NULL,
  lines = NULL,
  dbdir = NULL,
  db = td_connect()
)
}
\arguments{
\item{provider}{a list (character vector) of provider(s) to be included in the
database. By default, will install \code{itis}.  See details for a list of
recognized provider.
available provider automatically.}

\item{schema}{One of "dwc" (for Darwin Core data) or "common"
(for the Common names table.)}

\item{version}{Which version of the taxadb provider database should we use?
defaults to latest.  See \link{tl_import} for details.}

\item{overwrite}{Should we overwrite existing tables? Default is \code{TRUE}.
Change to "ask" for interactive interface, or \code{TRUE} to force overwrite
(i.e. updating a local database upon new release.)}

\item{lines}{number of lines that can be safely read in to memory at once.
Leave at default or increase for faster importing if you have
plenty of spare RAM.}

\item{dbdir}{a location on your computer where the database
should be installed. Defaults to user data directory given by
\verb{[tools::R_user_dir()]}.}

\item{db}{connection to a database.  By default, taxadb will set up its own
fast database connection.}
}
\value{
path where database has been installed (invisibly)
}
\description{
create a local taxonomic database
}
\details{
Authorities currently recognized by taxadb are:
\itemize{
\item \code{itis}: Integrated Taxonomic Information System, \verb{https://www.itis.gov}
\item \code{ncbi}:  National Center for Biotechnology Information,
\url{https://www.ncbi.nlm.nih.gov/taxonomy}
\item \code{col}: Catalogue of Life, \url{http://www.catalogueoflife.org/}
\item \code{gbif}: Global Biodiversity Information Facility, \url{https://www.gbif.org/}
\item \code{ott}: OpenTree Taxonomy:
\url{https://github.com/OpenTreeOfLife/reference-taxonomy}
\item \code{iucn}: IUCN Red List, https://iucnredlist.org
\item \code{itis_test}: a small subset of ITIS, cached locally with the package for testing purposes only
}
}
\examples{
\donttest{
  \dontshow{
   ## All examples use a temporary directory
   Sys.setenv(TAXADB_HOME=file.path(tempdir(), "taxadb"))
   options("taxadb_default_provider"="itis_test")

  }
  ## Install the ITIS database
  td_create()

  ## force re-install:
  td_create( overwrite = TRUE)

}
}
