% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_names.R
\name{clean_names}
\alias{clean_names}
\title{Clean taxonomic names}
\usage{
clean_names(
  names,
  fix_delim = TRUE,
  binomial_only = TRUE,
  remove_sp = TRUE,
  ascii_only = TRUE,
  lowercase = TRUE,
  remove_punc = FALSE
)
}
\arguments{
\item{names}{a character vector of taxonomic names (usually species names)}

\item{fix_delim}{Should we replace separators \code{.}, \verb{_}, \code{-}
with spaces? e.g. 'Homo.sapiens' becomes 'Homo sapiens'.
logical, default TRUE.}

\item{binomial_only}{Attempt to prune name to a binomial name, e.g.
Genus and species (specific epithet), e.g. \verb{Homo sapiens sapiens}
becomes \verb{Homo sapiens}. logical, default \link{TRUE}.}

\item{remove_sp}{Should we drop unspecified species epithet designations?
e.g. \verb{Homo sp.} becomes \code{Homo} (thus only matching against genus level ids).
logical, default \link{TRUE}.}

\item{ascii_only}{should we coerce strings to ascii characters?
(see \code{\link[stringi:stri_trans_general]{stringi::stri_trans_general()}})}

\item{lowercase}{should names be coerced to lower-case to provide
case-insensitive matching?}

\item{remove_punc}{replace all punctuation but apostrophes with a space,
remove apostrophes}
}
\description{
A utility to sanitize taxonomic names to increase
probability of resolving names.
}
\details{
Current implementation is limited to handling a few
common cases. Additional extensions may be added later.
A goal of the \code{clean_names} function is that any
modification rule of the name strings be precise, atomic, and
toggle-able, rather than relying on clever but more opaque rules and
arbitrary scores. This utility should always be used with care, as
indiscriminate modification of names may result in successful but inaccurate
name matching. A good pattern is to only apply this function to the subset
of names that cannot be directly matched.
}
\examples{
clean_names(c("Homo sapiens sapiens", "Homo.sapiens", "Homo sp."))

}
