## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(tabtibble)
library(dplyr)

## ----example-setup------------------------------------------------------------
d_tab <-
  mtcars %>%
  tidyr::nest(table = !"cyl") %>%
  dplyr::mutate(
    caption = glue::glue("Cars with {cyl} cylinders")
  ) %>%
  new_tab_tibble()

## ----print, results='asis'----------------------------------------------------
knit_print(d_tab)

