% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableMatrix.R
\name{tableMatrix}
\alias{tableMatrix}
\title{tableMatrix constructor}
\usage{
tableMatrix(dataList, tabCol, matCol, dims = NULL, dimNames = NULL,
  aidData = list(), dataType = NULL)
}
\arguments{
\item{dataList}{Dataset(s) in the form of data.frame or data.table or list of data.frames or data.tables.
All datasets must have the same meta data columns, matrix parts can be different.}

\item{tabCol}{Integer or character vector or list of these vectors. Specifies column 
names or indices of meta data part. For list input, names \code{j} or \code{r} can be used. 
List name \code{j} indicates that column names or indices are specified, name \code{r} indicates 
range of column names or indices. By default or when a vector is provided, \code{j} is used.}

\item{matCol}{Integer or character vector or list of these vectors. Specifies column
names or indices of main data part. For list input, names \code{j} or \code{r} can be used
as in \code{tabCol}.}

\item{dims}{Numeric vector or list of vectors. Specifies dimensions for the \code{matDim} part.
By default with no dimension details given by user, main data is considered to be vectors
with one dimension.}

\item{dimNames}{Character vector. Specifies dimension names in \code{matDim} for each
element of \code{dims} parameter. If not specified these names are generated automatically.}

\item{aidData}{Aid structures generally in the form of a list.}

\item{dataType}{Named list. Contains names of groups of attributes, elements are attributes which
belong to the group.}
}
\value{
A \code{tableMatrix} object
}
\description{
\code{tableMatrix} constructor, creates tableMatrix object from a list of 
data.frames or data.tables. It is useful for datasets with the following 
structure: first set of columns of varying types is intended as meta data,
second set of columns of the same type is intended as main data. 
\code{tableMatrix} combines strengths of data.table (access via bracket 
to the meta data part) and matrix (main data). It also stores dimensions of main data,
thus allowing to combine rows of varying lengths into one object. As in \code{tableList},
\code{tableMatrix} can carry any additional aid data and data types groups.
}
\details{
\code{tableMatrix} is a S3 class that consists of 4 parts. 
\code{tab} - table part - is used for storing meta data, 
\code{mat} - matrix part - for storing main data and \code{matDim} - dimensions part - for 
dimensions of main data. 
\code{mat} is a list of matrices. \code{tab} is a data.table. In \code{tab} first column \code{tm.matN} 
is the matrix number in \code{mat}, second column \code{tm.matRow} is the row in the matrix. 
\code{matDim} is \code{data.table}. In \code{matDim} for each matrix number \code{tm.matN} dimensions
can be specified with user defined dimensions. \code{dataType} is a list which contains names of groups of
attributes and vectors of attributes belonging to it.
Default print of \code{tableMatrix} is the print of the \code{tab} part without \code{tm.matN} and 
\code{tm.matRow} columns.
}
\examples{

data(images8By8)
dim(images8By8)

data(images10By10)
dim(images10By10)
images10By10DT <- data.table::as.data.table(images10By10)

# Generate tableMatrix from data.frame images8By8: use columns 1:3 as meta data and 
# columns 4:ncol(images8By8) as main data 
TM <- tableMatrix(images8By8, 1:3, 4:ncol(images8By8))
matDim(TM) # show matDim
tab(TM) # show meta data part of tableMatrix
head(mat(TM)[[1]]) # show head of main data part

# Generate tableMatrix from data.frame images8By8: use columns "direction" and "dimY"
# as meta data and columns 4:ncol(images8By8) as main data 
tableMatrix(images8By8, c("direction","dimY"), 4:ncol(images8By8))

# User defined dimensions with default names
TM <- tableMatrix(images8By8, c("direction","dimX","dimY"), 4:ncol(images8By8), c(8,8))
matDim(TM)

# User defined dimensions with custom names
dims <- c(8,8)
names(dims) <- c("dimX", "dimY")

TM <- tableMatrix(images8By8, 1:3, 4:ncol(images8By8), dims)
matDim(TM)

# tabCol and matCol list input with "j" option
# Column indices: first 3 columns in tab, rest in mat
tableMatrix(images8By8, list(j=1:3), list(j=4:ncol(images8By8)))
# Column names: columns "direction" and "dimY" in tab, 
# columns "pixel1" and "pixel2" in mat
tableMatrix(images8By8, list(j=c("direction","dimY")), list(j=c("pixel1","pixel2")))

# tabCol and matCol list input with "r" option
# Column indices: first 3 columns in tab, rest in mat
tableMatrix(images8By8, list(r=c(1,3)), list(r=c(4,ncol(images8By8))))
# Same with column names
tableMatrix(images8By8, list(r=c("direction","dimY")), list(r=c("pixel1","pixel100")))

# data.table as the start dataset
tableMatrix(images10By10DT, 1:3, 4:ncol(images10By10DT))

# data.frame and data.table with different main data parts -> two matrices in mat.
# Elements in tabCol and matCol lists correspond to images8By8 and images10By10DT
# respectively
TM <- tableMatrix(list(images8By8, images10By10DT),
list(r=c("direction","dimY"), j=c("direction","dimX","dimY")),
list(4:ncol(images8By8),4:ncol(images10By10DT)))
matDim(TM)
length(mat(TM)) # 2 matrices in mat

# User defined named dimensions
TM <- tableMatrix(list(images8By8, images10By10),
list(r=c("direction","dimY"), j=c("direction","dimX","dimY")),
list(c(4:ncol(images8By8)),c(4:ncol(images10By10))),list(c(8,8),c(10,10)),
dimNames =c("dimX", "dimY"))
matDim(TM)

# Same main data parts -> only one matrix in mat
TM <- tableMatrix(list(images8By8, images8By8), 
list(r=c("direction","dimY"), j=c("direction","dimX","dimY")),
list(j=4:ncol(images8By8),4:ncol(images8By8)))
matDim(TM)
length(mat(TM)) # 1 matrix in mat

# dataType support
TM <- tableMatrix(images10By10, 1:3, 4:ncol(images10By10), 
dataType=list("group1"="direction", "group2"=c("dimX","dimY")))
dataType(TM)

}
\seealso{
\code{\link{getRowRepo.tableMatrix}}, \code{\link{getRowDim.tableMatrix}},
   \code{\link{merge.tableMatrix}}, \code{\link{rbind.tableMatrix}}
}
