% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableMatrix.R
\name{getRow.tableMatrix}
\alias{getRow.tableMatrix}
\alias{setRow.tableMatrix}
\title{Get or set row from the matrix attribute}
\usage{
\method{getRow}{tableMatrix}(obj, i = NULL, repo = NULL, ...)

\method{setRow}{tableMatrix}(obj, value, i = NULL, repo = NULL, ...)
}
\arguments{
\item{obj}{\code{tableMatrix} object.}

\item{i}{Integer. Row index in \code{tab}.}

\item{repo}{Numeric vector. Vector with 2 elements - matN and matRow.}

\item{...}{Passed arguments.}

\item{value}{Vector for setting value.}
}
\value{
Row from the matrix part.
}
\description{
\code{tableMatrix} method to get or set a row from the matrix attribute.
}
\examples{

data(images8By8)
data(images10By10)

# Create tableMatrix from images8By8 and images10By10
TM <- tableMatrix(list(images8By8, images10By10), list(1:3, 1:3),
list(4:ncol(images8By8),4:ncol(images10By10)))

# Row 91 in tab(TM) corresponds to second matrix, first row 
row <- getRow(TM, 91)

# Row 91 in tab(TM) corresponds to second matrix, first row 
getRow(TM, repo=c(2,1))

# Change matrix row corresponding to row 91 in tab(TM) 
TM <- setRow(TM, rep(2,length(row)), 91)
getRow(TM, 91)

}
