% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabmeans_svy.R
\name{tabmeans.svy}
\alias{tabmeans.svy}
\title{Create Table Comparing Group Means (for Complex Survey Data)}
\usage{
tabmeans.svy(
  formula,
  design,
  columns = c("xgroups", "p"),
  parenth = "sd",
  sep.char = ", ",
  xlevels = NULL,
  yname = NULL,
  text.label = NULL,
  decimals = 1,
  anova.svyglm.list = NULL,
  formatp.list = NULL,
  n.headings = FALSE,
  N.headings = FALSE,
  kable = TRUE
)
}
\arguments{
\item{formula}{Formula, e.g. \code{BMI ~ Sex}.}

\item{design}{Survey design object from \code{\link[survey]{svydesign}}.}

\item{columns}{Character vector specifying what columns to include. Choices
for each element are \code{"n"} for total sample size, \code{"overall"} for
overall mean, \code{"xgroups"} for \code{x} group means, \code{"diff"} for
difference in \code{x} group means (this one and the next two are only
available for binary \code{x}), \code{"diffci"} for 95% CI for difference in
\code{x} group means, \code{"diff.ci"} for difference in group means and 95%
confidence interval, and \code{"p"} for p-value.}

\item{parenth}{Character string specifying what statistic to display in
parentheses after the means. Choices are \code{"none"}, \code{"sd"},
\code{"se"},  \code{"t.ci"}, \code{"z.ci"}, \code{"range"}, and
\code{"minmax"}.}

\item{sep.char}{Character string with separator to place between lower and
upper bound of confidence intervals. Typically \code{"-"} or \code{", "}.}

\item{xlevels}{Character vector with labels for the levels of \code{x}, used
in column headings.}

\item{yname}{Character string with a label for the \code{y} variable.}

\item{text.label}{Character string with text to put after the \code{y}
variable name, identifying what cell values and parentheses represent}

\item{decimals}{Numeric value specifying number of decimal places for numbers
other than p-values.}

\item{anova.svyglm.list}{List of arguments to pass to
\code{\link[survey]{anova.svyglm}}. Only used if \code{x} has three or more
levels.}

\item{formatp.list}{List of arguments to pass to \code{\link[tab]{formatp}}.}

\item{n.headings}{Logical value for whether to display group sample sizes in
parentheses in column headings.}

\item{N.headings}{Logical value for whether to display weighted sample sizes
in parentheses in column headings.}

\item{kable}{Logical value for whether to return a
\code{\link[knitr]{kable}}.}
}
\value{
\code{\link[knitr]{kable}} or character matrix.
}
\description{
Creates a table comparing the mean of \code{y} across levels of \code{x}.
}
\details{
Basically \code{\link{tabmeans}} for complex survey data. Relies heavily on
the \pkg{survey} package.
}
\examples{
# Create survey design object
library("survey")
design <- svydesign(
  data = tabsvydata,
  ids = ~sdmvpsu,
  strata = ~sdmvstra,
  weights = ~wtmec2yr,
  nest = TRUE
)

# Compare mean BMI by sex
(meanstable <- tabmeans.svy(BMI ~ Sex, design = design))


}
