% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tLagPropOdds.R
\name{tLagPropOdds}
\alias{tLagPropOdds}
\title{Estimation of the Odds Ratio in a Proportional Odds Model with Censored
  Time-lagged Outcome}
\usage{
tLagPropOdds(data, ..., ti = NULL, td = NULL, itmax = 500, tol = 1e-05)
}
\arguments{
\item{data}{A data.frame object. A data.frame containing all observed data.
At a minimum, this data.frame must contain columns with headers 
"id", "U", "delta", "Cat" and "A". If the time-independent component of
the estimator is to be included, data.frame must also contain the 
bases of f(X). If the time-dependent component is included, data.frame
must also contain the bases of h(X,L) as well as the time intervals with
column headers \{"tstart", "tstop"\} or \{"start","stop"\}. See Details for
additional information.}

\item{...}{Ignored. Included to require named inputs.}

\item{ti}{A character or integer vector or NULL. The columns of data to be
included in the time-independent component of the estimator, 
f_m(X) m = 0, ..., M.  If NULL, the time-independent component is excluded 
from the AIPWCC estimator. See Details for additional information.}

\item{td}{A character or integer vector or NULL. The columns of data to be
included in the time-dependent component of the estimator, 
h_l(X,Lbar), l = 1, ..., L. If NULL, the time-dependent component is 
excluded from the AIPWCC estimator. See Details for additional information.}

\item{itmax}{An integer object. The maximum number of iterations for the
Newton-Raphson algorithm used to estimate parameters alpha and beta.}

\item{tol}{A numeric object. The value at which the Newton-Raphson is 
deemed to have converged.}
}
\value{
An S3 object of class tLagObj containing a list. The
  elements of the list correspond to the selected AIPWCC and/or IPWCC
  estimators. For each estimator, two matrix objects are returned: $logOdds
  contains the estimated beta parameters, their standard errors estimated
  using the sandwich estimator, the 95\% confidence intervals,
  and the p-values for the log odds ratio; $odds
  contains the estimated odds ratio, their standard errors estimated
  using the delta method, and the 95\% confidence intervals. The
  S3 object has an additional attribute, "type" giving a verbose 
  description of the components contained in the estimator.
}
\description{
Inverse probability weighted complete case (IPWCC) and augmented inverse 
 probability weighted complete case (AIPWCC) estimators for the odds ratio 
 in a proportional odds model with time-lagged ordered categorical outcome 
 in a randomized clinical trial.
}
\details{
At a minimum, the data provided for the analysis must contain the
  following information:
  \describe{
    \item{id:}{A unique participant identifier.}
    \item{U:}{The time to ascertainment of category or censoring.}
    \item{delta:}{The indicator of ascertainment of category (1 if U is 
                  the time to ascertainment;
                  0 otherwise).}
    \item{Cat:}{The ordered outcome category. Data must be provided as
                a factor or an integer or be able to be converted to an 
                integer without
                loss of information. If participant was censored
                (delta = 0), Cat can take any integer-like value or NA.}
    \item{A:}{The treatment received. Data must be provided as
              a factor or an integer or be able to be converted to an 
              integer without loss of information. }
  }
With the exception of Cat, data must be complete.

If the time-independent component is to be included in the AIPWCC estimator,
  data must also include the time-independent basis functions 
  f_m(X) m = 0, ..., M. If the intercept (f_0) term is not provided, it 
  will be added by the software.

If the time-dependent component is to be included in the AIPWCC estimator,
  the data.frame must be a time-dependent dataset as described by package 
  survival. Specifically, the time-dependent data must be specified for 
  intervals (start,stop], and the data must include the following 
  additional columns:
  \describe{
     \item{tstart:}{The lower boundary of the time interval to which the
                    data pertain.}
     \item{tstop:}{The upper boundary of the time interval to which the
                   data pertain.}
  }
  Note that column headers \{"start", "stop"\} are also accepted.

  The various combinations of inputs ti and td yield the following:
  \describe{
     \item{ti = NULL, td = NULL}{the IPWCC estimate is returned. 
     (denoted as IPW in the simulations of the original manuscript.)}
     \item{ti != NULL, td != NULL}{the IPWCC and the full 
                                   AIPWCC estimates are returned. 
     (denoted as AIPW2 in the simulations of the original manuscript.)}
     \item{ti = NULL, td != NULL}{the IPWCC and the partial, time-independent 
                                  AIPWCC estimates are returned. 
     (denoted as AIPW1 in the simulations of the original manuscript.)}
     \item{ti = NULL, td != NULL}{the IPWCC and the partial, time-dependent 
                                  AIPWCC estimates are returned. 
     (not discussed in the simulations of the original manuscript.)}
  }

If a treatment subgroup has <5\% censoring, a message is generated and
  the treatment subgroup is removed from the time-dependent component of the
  AIPWCC estimator. If there is no censoring, the IPWCC estimator approaches
  the usual proportional odds estimator.
}
\examples{

data(tLagData)

# full AIPWCC estimator
tLagPropOdds(data = tLagData, ti = "x", td = c("hospStatus", "daysOut"))

# partial, time-dependent AIPWCC estimator
tLagPropOdds(data = tLagData, td = c("hospStatus", "daysOut"))

# partial, time-independent AIPWCC estimator
tLagPropOdds(data = tLagData, ti = "x")
}
