% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmc.R
\name{cmc}
\alias{cmc}
\alias{cmc,data.frame-method}
\title{cross mapping cardinality}
\usage{
\S4method{cmc}{data.frame}(
  data,
  cause,
  effect,
  libsizes = NULL,
  E = 3,
  tau = 1,
  k = pmin(E^2),
  lib = NULL,
  pred = NULL,
  dist.metric = "L1",
  threads = length(pred),
  parallel.level = "low",
  bidirectional = TRUE,
  progressbar = TRUE
)
}
\arguments{
\item{data}{observation data.}

\item{cause}{name of causal variable.}

\item{effect}{name of effect variable.}

\item{libsizes}{(optional) number of time points used.}

\item{E}{(optional) embedding dimensions.}

\item{tau}{(optional) step of time lags.}

\item{k}{(optional) number of nearest neighbors.}

\item{lib}{(optional) libraries indices.}

\item{pred}{(optional) predictions indices.}

\item{dist.metric}{(optional) distance metric (\code{L1}: Manhattan, \code{L2}: Euclidean).}

\item{threads}{(optional) number of threads to use.}

\item{parallel.level}{(optional) level of parallelism, \code{low} or \code{high}.}

\item{bidirectional}{(optional) whether to examine bidirectional causality.}

\item{progressbar}{(optional) whether to show the progress bar.}
}
\value{
A list
\describe{
\item{\code{xmap}}{cross mapping results}
\item{\code{cs}}{causal strength}
\item{\code{varname}}{names of causal and effect variable}
\item{\code{bidirectional}}{whether to examine bidirectional causality}
}
}
\description{
cross mapping cardinality
}
\examples{
sim = logistic_map(x = 0.4,y = 0.4,step = 45,beta_xy = 0.5,beta_yx = 0)
cmc(sim,"x","y",E = 4,k = 15,threads = 1)

}
\references{
Tao, P., Wang, Q., Shi, J., Hao, X., Liu, X., Min, B., Zhang, Y., Li, C., Cui, H., Chen, L., 2023. Detecting dynamical causality by intersection cardinal concavity. Fundamental Research.
}
