% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poly.R
\name{idpoly}
\alias{idpoly}
\title{Polynomial model with identifiable parameters}
\usage{
idpoly(A = 1, B = 1, C = 1, D = 1, F1 = 1, ioDelay = 0, Ts = 1,
  noiseVar = 1, intNoise = F, unit = c("seconds", "minutes", "hours",
  "days")[1])
}
\arguments{
\item{A}{autoregressive coefficients}

\item{B, F1}{coefficients of the numerator and denominator respectively
of the deterministic model between the input and output}

\item{C, D}{coefficients of the numerator and denominator respectively
of the stochastic model}

\item{ioDelay}{the delay in the input-output channel}

\item{Ts}{sampling interval}

\item{noiseVar}{variance of the white noise source (Default=\code{1})}

\item{intNoise}{Logical variable indicating presence or absence of integrator
in the noise channel (Default=\code{FALSE})}

\item{unit}{time unit (Default=\code{"seconds"})}
}
\description{
Creates a polynomial model with identifiable coefficients
}
\details{
Discrete-time polynomials are of the form
\deqn{
 A(q^{-1}) y[k] = \frac{B(q^{-1})}{F1(q^{-1})} u[k] + 
 \frac{C(q^{-1})}{D(q^{-1})} e[k] 
}
}
\examples{
# define output-error model
mod_oe <- idpoly(B=c(0.6,-0.2),F1=c(1,-0.5),ioDelay = 2,Ts=0.1,
noiseVar = 0.1)

# define box-jenkins model with unit variance
B <- c(0.6,-0.2)
C <- c(1,-0.3)
D <- c(1,1.5,0.7)
F1 <- c(1,-0.5)
mod_bj <- idpoly(1,B,C,D,F1,ioDelay=1)

}

