% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_safety_of_advice.R
\name{get_safety_of_advice}
\alias{get_safety_of_advice}
\title{get_safety_of_advice}
\usage{
get_safety_of_advice(
  data,
  triagelevel_correct,
  triagelevel_advice,
  order_triagelevel,
  apps = NULL,
  CI = FALSE
)
}
\arguments{
\item{data}{A dataframe}

\item{triagelevel_correct}{A string indicating the column name storing the correct triage solutions}

\item{triagelevel_advice}{A string indicating the column name storing the recommendation of a symptom checker for a case}

\item{order_triagelevel}{A vector indicating the order of triage levels. The triage level with highest urgency should be the first value and the triage level with lowest urgency the last value.}

\item{apps}{A string indicating the column name storing the app names (optional)}

\item{CI}{A Boolean (TRUE or FALSE) indicating whether 95\% confidence intervals should be output (optional)}
}
\value{
A list containing both a raw number and the percentage of safe advice for one or multiple symptom checkers
}
\description{
Calculates the safety of advice for one or multiple symptom checkers
}
\examples{
data(symptomcheckRdata)
safety_of_advice <- get_safety_of_advice(
  data = symptomcheckRdata,
  triagelevel_correct = "Goldstandard_solution",
  triagelevel_advice = "Triage_advice_from_app",
  order_triagelevel = c("Emergency", "Non-Emergency", "Self-care"),
  apps = "App_name",
  CI = TRUE
  )
}
