% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.R
\name{vcov.msel}
\alias{vcov.msel}
\title{Calculate Variance-Covariance Matrix for a msel Object.}
\usage{
\method{vcov}{msel}(
  object,
  ...,
  type = object$cov_type,
  n_cores = object$other$n_cores,
  n_sim = object$other$n_sim,
  recalculate = FALSE
)
}
\arguments{
\item{object}{an object of class \code{msel}.}

\item{...}{further arguments (currently ignored).}

\item{type}{character representing the type of the asymptotic covariance 
matrix estimator. It takes the same values as \code{cov_type} parameter of
the \code{\link[switchSelection]{msel}} function.}

\item{n_cores}{positive integer representing the number of CPU cores used for 
parallel computing. If possible it is highly recommend to set it equal to
the number of available physical cores especially when the system of
ordered equations has 2 or 3 equations.}

\item{n_sim}{integer representing the number of GHK draws when there are
more than 3 ordered equations. Otherwise alternative (much more efficient) 
algorithms will be used to calculate multivariate normal probabilities.}

\item{recalculate}{logical; if \code{TRUE} then covariance matrix will be
recalculated even if 'type' is the same as 'cov_type' input argument
of the model.}
}
\value{
Returns numeric matrix which represents estimate of the asymptotic 
covariance matrix of model's parameters.
}
\description{
Return the variance-covariance matrix of the parameters of
msel model.
}
\details{
Argument \code{type} is closely related to the argument 
\code{cov_type} of \code{\link[switchSelection]{msel}} function. 
See 'Details' and 'Usage' sections of \code{\link[switchSelection]{msel}} 
for more information on \code{cov_type} argument.
}
