% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.msel}
\alias{coef.msel}
\title{Coefficients extraction method for msel.}
\usage{
\method{coef}{msel}(
  object,
  ...,
  eq = NULL,
  eq2 = NULL,
  eq3 = NULL,
  regime = NULL,
  type = "coef"
)
}
\arguments{
\item{object}{an object of class "msel".}

\item{...}{further arguments (currently ignored).}

\item{eq}{an integer representing the index of the ordered equation.}

\item{eq2}{an integer representing the index of the continuous equation.}

\item{eq3}{an integer representing the index of the alternative of the
multinomial equation.}

\item{regime}{an integer representing a regime of the continuous equation.}

\item{type}{a character representing a type of the output. Possible options
are \code{"coef"}, \code{"coef2"}, \code{coef_lambda}, 
\code{"coef_var"}, \code{"coef3"}, \code{"cuts"}, \code{"cov"}, 
\code{"cov1"}, \code{"var"}, \code{"cov2"}, \code{"cov3"}, 
and \code{marginal}.
See 'Details' for additional information.}
}
\value{
See 'Details' section.
}
\description{
Extract coefficients and other estimates from msel object.
}
\details{
Consider the notations from the 'Details' section of 
\code{\link[switchSelection]{msel}}.

\strong{Mean coefficients of the ordinal equations}

Suppose that \code{type = "coef"}. Then estimates of the \eqn{\gamma_{j}} 
coefficients are returned for each \eqn{j\in\{1,...,J\}}. 
If \code{eq = j} then only estimates of the \eqn{\gamma_{j}} coefficients 
are returned.

\strong{Variance coefficients of the ordinal equations}

Suppose that \code{type = "coef_var"}. Then estimates of the
\eqn{\gamma_{j}^{*}} coefficients are returned for each 
\eqn{j\in\{1,...,J\}}. If \code{eq = j} then only estimates of 
\eqn{\gamma_{j}^{*}} coefficients are returned.

\strong{Coefficients of the continuous equations}

Suppose that \code{type = "coef2"}. Then estimates of the \eqn{\beta_{r}} 
coefficients are returned for each \eqn{r\in\{0,...,R - 1\}}. 
If \code{eq2 = k} then only estimates for the \eqn{k}-th continuous equation 
are returned. If \code{regime = r} then estimates of the \eqn{\beta_{r}}
coefficients are returned for the \code{eq2}-th continuous equation. 
Herewith if \code{regime} is not \code{NULL} and \code{eq2} is \code{NULL} 
it is assumed that \code{eq2 = 1}.

\strong{Selectivity terms}

Suppose that \code{type = "coef_lambda"}. Then estimates of the coefficients
associated with the selectivity terms are returned for each 
\eqn{r\in\{0,...,R - 1\}}. If \code{eq2 = k} then only estimates for the 
\eqn{k}-th continuous equation are returned. If \code{regime = r} then 
estimates of the coefficients of the selectivity terms are returned for the 
\code{eq2}-th continuous equation.

\strong{Thresholds of the ordinal equations}

Suppose that \code{type = "cuts"} or \code{type = "thresholds"}. Then 
estimates of the \eqn{c_{j}} cuts (thresholds) are returned for each 
\eqn{j\in\{1,...,J\}}. If \code{eq = j} then only estimates of the 
\eqn{c_{j}} cuts are returned.


\strong{Covariances between the random errors of the ordinal equations}

Suppose that \code{type = "cov1"}. Then estimate of the covariance matrix of
\eqn{u_{i}} is returned. If \code{eq = c(a, b)} then the function returns
\eqn{(a, b)}-th element of this matrix i.e. an element from the
\code{a}-th row and the \code{b}-th column which represents an estimate of
\eqn{Cov(u_{ai}, u_{bi})}.

\strong{Covariances between the random errors of the ordinal and continuous 
equations}

Suppose that \code{type = "cov12"}. Then estimates of the covariances between
random errors of the ordinal \eqn{u_{i}} and cotninuous \eqn{\varepsilon_{i}} 
equations are returned. If \code{eq2 = k} then covariances with random errors 
of the \code{k}-th continuous equation are returned. If in addition 
\code{eq = j} and \code{regime = r} then the function returns an estimate of 
\eqn{Cov(u_{ji}, \varepsilon_{ri})} for the \code{k}-th continuous equation. 
If \code{eq2 = NULL} it is assumed that \code{eq2 = 1}.

\strong{Variances of the random errors of the continuous equations}

Suppose that \code{type = "var"}. Then estimates of the variances of 
\eqn{\varepsilon_{i}} are returned. If \code{eq2 = k} then estimates only for
the \eqn{k}-th continuous equation are returned. If in addition 
\code{regime = r} then estimate of the \eqn{Var(\varepsilon_{ri})} is 
returned. Herewith if \code{regime} is not \code{NULL} and \code{eq2} is 
\code{NULL} it is assumed that \code{eq2 = 1}.

\strong{Covariances between the random errors of the continuous equations}

Suppose that \code{type = "cov2"}. Then estimates of the covariances between
random errors of different continuous equations in different regimes are 
returned. If \code{eq2 = c(a, b)} and \code{regime = c(c, d)} then function 
returns an estimate of the covariance of random errors of the \code{a}-th 
and \code{b}-th continuous equations in the regimes \code{c} and \code{d} 
correspondingly. If this covariance is not identifiable then \code{NA} value 
is returned.

\strong{Coefficients of the multinomial equation}

Suppose that \code{type = "coef3"}. Then estimates of the 
\eqn{\tilde{\gamma}_{j}} coefficients are returned for each 
\eqn{j\in\{0,...,\tilde{J} - 1\}}. If \code{eq3 = j} then only estimates of 
the \eqn{\tilde{\gamma}_{j}} coefficients are returned.

\strong{Covariances between the random errors of the multinomial equations}

Suppose that \code{type = "cov3"}. Then estimate of the covariance matrix of
\eqn{\tilde{u}_{i}} is returned. If \code{eq3 = c(a, b)} then the function 
returns \eqn{(a, b)}-th element of this matrix i.e. an element from the
\code{a}-th row and the \code{b}-th column which represents an estimate of
\eqn{Cov(\tilde{u}_{(a+1)i}, \tilde{u}_{(b+1)i})}.

\strong{Parameters of the marginal distributions}

Suppose that \code{type = "marginal"}. Then a list is returned which
\code{j}-th element is a numeric vector of estimates of the parameters
of the marginal distribution of \eqn{u_{ji}}.

\strong{Asymptotic covariance matrix}

Suppose that \code{type = "cov"}. Then estimate of the asymptotic covariance
matrix of the estimator is returned. Note that this estimate depends
on the \code{cov_type} argument of \code{\link[switchSelection]{msel}}.
}
