% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot.swdft}
\alias{plot.swdft}
\title{Plot method for 'swdft' object}
\usage{
\method{plot}{swdft}(x, freq_type = "cycles", fs = NULL,
  hertz_range = NULL, take_log = FALSE, log_thresh = 1e-05,
  use_fields = TRUE, scale_shrink = 0.9, zlim = NULL,
  xlab = "Window Position", ylab = "Frequency (Cycles/Window)",
  title = "SWDFT", cex_main = 1, cex_lab = 1, cex_axis = 1,
  xaxis_subset = NULL, custom_xaxis = NULL, custom_yaxis = NULL,
  col = "grayscale", display = TRUE, ...)
}
\arguments{
\item{x}{Object of class 'swdft'. If x$a is complex-valued, it is converted to the squared
modulus. If x$a is real-valued, then we assume that it represents the squared}

\item{freq_type}{Specify how to display the frequency axis. Either 'cycles' (default), 'fraction', or 'hertz'}

\item{fs}{sample rate. Used if freq_type='hertz'}

\item{hertz_range}{integer vector, given by (low, high). Specifies the range of hertz to display and
is only used when freq_type='hertz'}

\item{take_log}{logical. Whether to take the log before plotting}

\item{log_thresh}{numeric. Threshold for smallest possible value. Defaults to .000001, and is
used to keep plots from displaying of ~ -40.}

\item{use_fields}{logical. Determines whether we use image.plot from the fields package, or 'image'
from the graphics package. The advantage of image.plot is that we get a color scale, so the default is TRUE}

\item{scale_shrink}{Proportion between 0 and 1 to shrink the scale}

\item{zlim}{Custom z range}

\item{xlab}{Custom x-label}

\item{ylab}{Custom y-label}

\item{title}{Custom title}

\item{cex_main}{how large to make the title}

\item{cex_lab}{how large to make the labels}

\item{cex_axis}{how large to make the axis labels}

\item{xaxis_subset}{subset of x-axis (time / window position) for plotting}

\item{custom_xaxis}{Defaults to NULL. Otherwise, used to change the x-axis}

\item{custom_yaxis}{Defaults to NULL. Otherwise, used to change the y-axis}

\item{col}{defaults to grayscale, can also be 'tim.colors' from fields package}

\item{display}{logical. Defaults to TRUE, only used for testing purposes, so it should always be TRUE.}

\item{...}{optional arguments to match the plot generic function}
}
\description{
Plot method for 'swdft' object
}
