% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demod.R
\name{new_swdft_demod}
\alias{new_swdft_demod}
\title{Constructor function for class 'swdft_demod'}
\usage{
new_swdft_demod(x, f0, A_t, Phi_t, fitted, y, y_smooth, smooth, order,
  passfreq)
}
\arguments{
\item{x}{numeric vector}

\item{f0}{numeric scalar. Frequency to demodulate}

\item{A_t}{extracted amplitude from y_smooth}

\item{Phi_t}{extracted phase from y_smooth}

\item{fitted}{fitted values}

\item{y}{non-smoothed demodulated signal}

\item{y_smooth}{smoothed demodulated signal}

\item{smooth}{character. Type of smoothing to use, accepts either 'ma', 'double_ma',
or 'butterworth' (the default)}

\item{order}{moving average parameter if 'smooth' argument equals 'ma' or 'double_ma'. Defaults to 5}

\item{passfreq}{numeric frequency used as the passfreq in the low-pass filter}
}
\value{
list with the following elements
\itemize{
  \item coefficients. A matrix of parameters, the three columns are: 1. amplitude 2. phase, and 3. frequency.
  There is only more that one row used when multiple frequencies are fit sequentially.
  \item fitted. fitted values of cosine regression model
  \item residuals. residuals of cosine regression model
  \item data. original signal used to fit cosine regression
  \item list with the filter used ('smooth') and parameters ('order' for 'ma' or 'double_ma', 'passfreq' for butterworth)
  \item list w/ the demodulated signal, and smoothed demodulated signal
}
}
\description{
Constructor function for class 'swdft_demod'
}
