% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demod.R
\name{complex_demod}
\alias{complex_demod}
\title{Complex Demodulation}
\usage{
complex_demod(x, f0, smooth = "butterworth", order = 5,
  passfreq = 0.1, match_swdft = FALSE, window_size = NULL)
}
\arguments{
\item{x}{numeric vector}

\item{f0}{numeric scalar. Frequency to demodulate}

\item{smooth}{character. Type of smoothing to use, accepts either 'ma', 'double_ma',
or 'butterworth' (the default)}

\item{order}{moving average parameter if 'smooth' argument equals 'ma' or 'double_ma'. Defaults to 5}

\item{passfreq}{numeric scalar. Pass frequency used in butterworth low-pass filter. Defaults to .1
which corresponds to a pass frequency of 2 * f0.}

\item{match_swdft}{logical. Only used to demonstrate equivalence w/ SWDFT when
a moving average filter is used. Otherwise, never used.}

\item{window_size}{defaults to NULL, only used when match_swdft=TRUE, so can ignore.}
}
\value{
An S3 'swdft_demod' object. See ?new_swdft_matching_demod for details.
}
\description{
Complex Demodulation
}
\references{
Chapter 7 of 'Fourier Analysis of Time-Series' by Peter Bloomfield and this
blog post: https://dankelley.github.io/r/2014/02/17/demodulation.html for the idea of using
a butterworth filter.
}
