% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w8margin_functions.R
\name{as.w8margin}
\alias{as.w8margin}
\alias{w8margin}
\alias{as.w8margin.data.frame}
\alias{as.w8margin.numeric}
\alias{as.w8margin.matrix}
\title{Weight Margin Objects}
\usage{
as.w8margin(
  target,
  varname,
  levels = NULL,
  samplesize = NULL,
  na.allow = FALSE,
  rebase.tol = 0.01,
  ...
)

\method{as.w8margin}{data.frame}(
  target,
  varname,
  levels = NULL,
  samplesize = NULL,
  na.allow = FALSE,
  rebase.tol = 0.01,
  ...
)

\method{as.w8margin}{numeric}(
  target,
  varname,
  levels = NULL,
  samplesize = NULL,
  na.allow = FALSE,
  rebase.tol = 0.01,
  ...
)

\method{as.w8margin}{matrix}(
  target,
  varname,
  levels = NULL,
  samplesize = NULL,
  na.allow = FALSE,
  rebase.tol = 0.01,
  byrow = TRUE,
  ...
)
}
\arguments{
\item{target}{Numbers specifying the desired target distribution of a
categorical variable, after rake weighting. Can be a numeric vector,
numeric matrix, or data frame with one (and only one) numeric column.
Unless \code{levels} is specified, vectors and matrices must be named, and
data frames must have a character or factor column specifying names. See
details.}

\item{varname}{Character vector specifying the name of the observed variable
that the \code{w8margin} object should match. Can take a NULL value for
data frames, in which case the original column name is used.}

\item{levels}{Optional character vector, specifying which numeric elements of
\code{target} match with each factor level in the observed data. Overrides
names specified in \code{target}.}

\item{samplesize}{Numeric with the desired target sample size for the
w8margin object. Defaults to the sum of \code{target}.}

\item{na.allow}{Logical specifying whether NA values should be allowed in
w8margin objects. If TRUE, w8margin objects must be imputed (such as with
\code{\link[=impute_w8margin]{impute_w8margin()}} before they can be used for weighting.}

\item{rebase.tol}{Numeric between 0 and 1. If targets are rebased, and the
rebased sample sizes differs from the original sample size by more than
this percentage, generates a warning.}

\item{...}{Other method-specific arguments, currently not used}

\item{byrow}{Logical, specifying how matrix targets should be converted to vectors.
If FALSE, the elements within columns will be adjacent
in the resulting w8margin object, otherwise elements within rows will be
adjacent.}
}
\value{
An object of class w8margin, with specified variable name and sample size.
}
\description{
Creates an object of class \code{w8margin}. Represents the
desired target distribution of a categorical variable, after
weighting (as a \emph{counts}, not percentage). w8margin objects are in the format
required by the 'survey' package's \code{\link[survey:rake]{survey::rake()}}and \code{\link[survey:postStratify]{survey::postStratify()}},
and are intended mostly for use with these functions. Methods exist for
numeric vectors, matrices, and data frames (see details).
}
\details{
w8margin objects are inputs to the \code{\link[survey:rake]{survey::rake()}}and
\code{\link[survey:postStratify]{survey::postStratify()}}. These functions require a
specific, highly-structured input format. For flexibility,
\code{as.w8margin()} can be used to convert a variety of common inputs into
the format needed by these functions.

\code{as.w8margin()} has methods for numeric vectors, numeric matrices, and
data frames. Each method has multiple ways of determining how to match
numeric elements of \code{target} with factor levels in the observed data.
For numeric vector and matrix inputs, the default is to match based on the
name of each element (for vectors) or the interaction of row and column
names of each element (for matrices). These names can be overridden by
specifying the \code{levels} parameter.

Data frame inputs must have either one or two columns. Two-column
data frames must have one numeric column and one character column. The
numeric column specifies the target distribution, while the character
column specifies how to match numeric elements with factor levels in the
observed data. If \code{varname} is NULL, a default value will be taken
from the name of the non-numeric column.

One-column data frames must have a numeric column. Row names are
converted to a character column in order to match numeric elements with
factor levels in the observed data. One-column data frames must specify a
\code{varname} parameter, and (unless \code{levels} is specified) must have
non-default row names. The \code{levels} parameter can be used with both
one- and two-column data frames.

Technically, \code{w8margin} objects are data frames with two
columns. The first column specifies levels in the observed factor variable,
and the \emph{name} of the first column indicates the name of the observed
factor variable. The second column is named "Freq" and indicates the
desired post-raking frequency of each category (as a \emph{count} rather than percentage).
The structure is designed for compatibility with the 'survey' package.
Because frequency is specified as a count, \code{\link[=rakesvy]{rakesvy()}} and \code{\link[=rakew8]{rakew8()}}
re-call \code{as.w8margin()} whenever weighting a data set to a new observed sample size.
Weight margins must be manually re-calculated for new sample sizes when using
\code{\link[survey:postStratify]{survey::postStratify()}} or \code{\link[survey]{rake}}.
}
\examples{
# Convert vector of percentages to w8margin
turnout2013_w8margin <- as.w8margin(
    c(voted = .715, `did not vote` = .285, ineligible = NA), 
    varname = "turnout2013", 
    na.allow = TRUE,
    samplesize = 1500)

# Convert matrix of percentages to w8margin
gender_educ_mat <- matrix(
    c(.15, .17, .17, .01, .19, .16, .14, .01),
    nrow = 2,
    byrow = TRUE, 
    dimnames = list(c("Male", "Female"), c("Low", "Medium", "High", NA)))
gender_educ_w8margin <- as.w8margin(gender_educ_mat, 
    varname = "gender_educ", samplesize = 2179)

# Convert data frame of counts to w8margin
# Keep default values for samplesize and varname
region_df <- data.frame(
    eastwest = c("east", "west"), Freq = c(425, 1754))
region_w8margin <- as.w8margin(region_df, 
                               levels = c("East Germany", "West Germany"), 
                               varname = NULL)

# Calculate rake weights using w8margin objects (without NAs)
require(survey)
gles17_dweighted <- svydesign(ids = gles17$vpoint, weights = gles17$dweight, 
    strata = gles17$eastwest, data = gles17, nest = TRUE)
rake(design = gles17_dweighted, 
     sample.margins = list(~gender_educ, ~eastwest),
     population.margins = list(gender_educ_w8margin, region_w8margin))


}
