% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svgtools.R
\name{summary_svg}
\alias{summary_svg}
\title{Print summary of SVG file structure in console}
\usage{
summary_svg(svg)
}
\arguments{
\item{svg}{XML document with SVG content.}
}
\description{
Print summary of SVG file structure in console
}
\details{
Prints helpful information to verify the content of the SVG file:
\itemize{
\item Named groups (XML elements 'g' with attribute 'id') and number of their child elements
\item Available frames (XML elements 'rect' with attribute 'id')
\item Used fonts, font sizes and font colors (in any XML elements with attributes 'font-family', 'font-size', 'fill' and 'stroke')
}
}
\examples{
#read SVG file
fpath <- system.file("extdata", "fig1.svg", package="svgtools")
svg <- read_svg(file = fpath)

#show a summary of SVG file
summary_svg(svg = svg)
}
