% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indichange.R
\name{indichange}
\alias{indichange}
\alias{rv}
\alias{rvse}
\alias{iv}
\alias{ralpha}
\alias{pralpha}
\title{Individual Change}
\usage{
rv(t)

rvse(t)

iv(t)

ralpha(t)

pralpha(t)
}
\arguments{
\item{t}{The contingency table for Svensson's method, a two-dimension matrix.}
}
\value{
\code{rv} and \code{iv} give the RV and IV value. \code{rvse} gives the standard
error of RV. \code{ralpha} and \code{pralpha} give the augmented correlation coefficient
and the corresponding p-value.
}
\description{
In Svensson's method, the individual change is described by the relative rank variance (RV),
the observable part, and the internal rank variance (IV), the unobservable part, together.
A measure of the closeness of observations to the rank transformable pattern of change is
defined as the augmented correlation coefficient (ralpha) and its p-value.
}
\examples{
x <- c (1:5,5:1)
y <- c(1:5,1,1,5,4,1)
z <- con_ta(x,y,)
rv(z)
rvse(z)
iv(z)
ralpha(z)
pralpha(z)
}
\seealso{
\code{\link{con_ta}} for generating contingency table. \code{\link{syschange}}
for systematic change. \code{\link{sresult}} for summary of Svensson's method analysis.
}
