% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suso_gql_interviews.R
\name{suso_gql_interviews}
\alias{suso_gql_interviews}
\title{Get all interviews}
\usage{
suso_gql_interviews(
  endpoint = NULL,
  workspace = NULL,
  user = NULL,
  password = NULL,
  token = NULL,
  assignmentId = NULL,
  clientKey = NULL,
  createdDate = NULL,
  errorsCount = NULL,
  identifyingData = NULL,
  interviewMode = NULL,
  notAnsweredCount = NULL,
  questionnaireId = NULL,
  questionnaireVersion = NULL,
  questionnaireVariable = NULL,
  responsibleName = NULL,
  responsibleRole = NULL,
  status = NULL,
  supervisorName = NULL,
  sortby_updateDateUtc = NULL,
  sortby_notAnsweredCount = NULL,
  sortby_createdDate = NULL,
  sortby_errorsCount = NULL,
  sortby_assignmentId = NULL,
  sortby_status = NULL,
  sortby_receivedByInterviewerAtUtc = NULL,
  sortby_responsibleName = NULL,
  take = NULL,
  skip = NULL
)
}
\arguments{
\item{endpoint}{GraphQL endpoint of your server}

\item{workspace}{Server Workspace, if NULL uses default}

\item{user}{your API username}

\item{password}{API password}

\item{token}{If Survey Solutions server token is provided \emph{apiUser} and \emph{apiPass} will be ignored}

\item{assignmentId}{Assignment ID}

\item{clientKey}{Interview key}

\item{createdDate}{Creation data of the interview}

\item{errorsCount}{number of errors}

\item{identifyingData}{Pre-loaded identifying data}

\item{interviewMode}{Interview mode (CAWI or CAPI)}

\item{notAnsweredCount}{number of unanswered questions}

\item{questionnaireId}{the questionnnaire id}

\item{questionnaireVersion}{the questionnaire version}

\item{questionnaireVariable}{the variable for the questionnaire}

\item{responsibleName}{Name of the person responsible}

\item{responsibleRole}{Role of the person responsible}

\item{status}{of the interview}

\item{supervisorName}{Name of the supervisor of the responsible user}

\item{sortby_updateDateUtc}{sort by updated at UTC time, either ASC for ascending or DESC for descending}

\item{sortby_notAnsweredCount}{sort by errors count, either ASC for ascending or DESC for descending}

\item{sortby_createdDate}{sort by creation date, either ASC for ascending or DESC for descending}

\item{sortby_errorsCount}{sort by number of errors, either ASC for ascending or DESC for descending}

\item{sortby_assignmentId}{sort by assignmentId, either ASC for ascending or DESC for descending}

\item{sortby_status}{sort by interview status, either ASC for ascending or DESC for descending}

\item{sortby_receivedByInterviewerAtUtc}{sort by date the table received the interview, either ASC for ascending or DESC for descending}

\item{sortby_responsibleName}{sort by the current responsible user, either ASC for ascending or DESC for descending}

\item{take}{take the specified integer numeber of interviews}

\item{skip}{skip the first integer number of interviews}
}
\value{
if successfull, returns a list with the (filtered) responses
}
\description{
Allows the user to retrieve filtered or unfiltered interview data.
}
\examples{
\dontshow{if (suso_gql_pwcheck()==200) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Requires Survey Solutions Server and API credentials

# Get all interviews without filter
suso_gql_interviews(endpoint = ep, user = usr,
password = pass, workspace = "primary")

# Select interviews which are not completed yet
suso_gql_interviews(endpoint = ep, user = usr,
password = pass, workspace = "primary", status = susoop_str$neq("COMPLETED"))

# Select interviews which have 3 or more errors
suso_gql_assignments(endpoint = ep, user = usr,
password = pass, workspace = "primary", errorsCount = susoop_num$gte(3))

# Select interviews which have less than 3 errors
suso_gql_assignments(endpoint = ep, user = usr,
password = pass, workspace = "primary", errorsCount = susoop_num$ngt(3))




\dontshow{\}) # examplesIf}
}
