% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_pycox.R
\name{get_pycox_init}
\alias{get_pycox_init}
\title{Get Pytorch Weight Initialization Method}
\usage{
get_pycox_init(
  init = "uniform",
  a = 0,
  b = 1,
  mean = 0,
  std = 1,
  val,
  gain = 1,
  mode = c("fan_in", "fan_out"),
  non_linearity = c("leaky_relu", "relu")
)
}
\arguments{
\item{init}{\code{(character(1))}\cr Initialization method, see details for list of implemented
methods.}

\item{a}{\code{(numeric(1))}\cr Passed to \code{uniform}, \code{kaiming_uniform}, and \code{kaiming_normal}.}

\item{b}{\code{(numeric(1))}\cr Passed to \code{uniform}.}

\item{mean, std}{\code{(numeric(1))}\cr Passed to \code{normal}.}

\item{val}{\code{(numeric(1))}\cr Passed to \code{constant}.}

\item{gain}{\code{(numeric(1))}\cr Passed to \code{xavier_uniform}, \code{xavier_normal}, and \code{orthogonal}.}

\item{mode}{\code{(character(1))}\cr Passed to \code{kaiming_uniform} and \code{kaiming_normal}, one of
\code{fan_in} (default) and \code{fan_out}.}

\item{non_linearity}{\code{(character(1))}\cr Passed to \code{kaiming_uniform} and \code{kaiming_normal}, one of
\code{leaky_relu} (default) and \code{relu}.}
}
\value{
No return value.
}
\description{
Helper function to return a character string with a populated pytorch weight
initializer method from \code{torch.nn.init}. Used in \link{build_pytorch_net} to define a weighting
function.
}
\details{
Implemented methods (with help pages) are
\itemize{
\item \code{"uniform"} \cr \code{reticulate::py_help(torch$nn$init$uniform_)}
\item \code{"normal"} \cr \code{reticulate::py_help(torch$nn$init$normal_)}
\item \code{"constant"} \cr \code{reticulate::py_help(torch$nn$init$constant_)}
\item \code{"xavier_uniform"} \cr \code{reticulate::py_help(torch$nn$init$xavier_uniform_)}
\item \code{"xavier_normal"} \cr \code{reticulate::py_help(torch$nn$init$xavier_normal_)}
\item \code{"kaiming_uniform"} \cr \code{reticulate::py_help(torch$nn$init$kaiming_uniform_)}
\item \code{"kaiming_normal"} \cr \code{reticulate::py_help(torch$nn$init$kaiming_normal_)}
\item \code{"orthogonal"} \cr \code{reticulate::py_help(torch$nn$init$orthogonal_)}
}
}

