% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_bootstrap.r
\name{rds.chain.boot.draws}
\alias{rds.chain.boot.draws}
\title{Draw RDS bootstrap resamples}
\usage{
rds.chain.boot.draws(chains, mm, dd, num.reps, keep.vars = NULL)
}
\arguments{
\item{chains}{A list whose entries are the chains
we want to resample}

\item{mm}{The mixing model}

\item{dd}{The degree distributions}

\item{num.reps}{The number of bootstrap resamples we want}

\item{keep.vars}{If not \code{NULL}, then the names of variables
from the original dataset we want appended to each bootstrap
resampled dataset (default is \code{NULL})}
}
\value{
A list of length \code{num.reps}; each entry in
the list has one bootstrap-resampled dataset
}
\description{
Draw bootstrap resamples for an RDS dataset, using
the algorithm described in the supporting online
material of Weir et al 2012 (see \code{\link[=rds.boot.draw.chain]{rds.boot.draw.chain()}} ).
}
