% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspline_init.R
\name{mspline_constant_coefs}
\alias{mspline_constant_coefs}
\title{Determine M-spline basis coefficients which give a constant function.}
\usage{
mspline_constant_coefs(mspline, logit = FALSE)
}
\arguments{
\item{mspline}{A list with components \code{knots} (vector of knots),
\code{degree} (polynomial degree) and \code{bsmooth} (logical for smoothness
constraint at boundary), defining an M-spline configuration.}

\item{logit}{If \code{TRUE} then the multinomial logit transform of the coefficients
is returned.  This is a vector of length one less than the number of coefficients,
with the rth element defined by \eqn{log(coefs[r+1] / coefs[1])}.}
}
\value{
A numeric vector of the coefficients.
}
\description{
This works by obtaining the coefficients of the corresponding
B-spline basis, which are equal if the B-spline is a constant
function.
}
\references{
Ramsay, J. O. (1988). Monotone regression splines in action. Statistical Science, 3(4): 425-441.
}
