% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_surv_explainer.R
\name{predict.surv_explainer}
\alias{predict.surv_explainer}
\title{Model Predictions for Survival Models}
\usage{
\method{predict}{surv_explainer}(object, newdata = NULL, output_type = "survival", times = NULL, ...)
}
\arguments{
\item{object}{an explainer object - model preprocessed by the \code{explain()} function}

\item{newdata}{data used for the prediction}

\item{output_type}{character, either \code{"risk"}, \code{"survival"} or \code{"chf"} depending on the desired output}

\item{times}{a numeric vector of times for the survival and cumulative hazard function predictions to be evaluated at. If \verb{"output_type == "risk"} this argument is ignored, if left \code{NULL} then it is extracted from \code{object$times}.}

\item{...}{other arguments, currently ignored}
}
\value{
A vector or matrix containing the prediction.
}
\description{
This function allows for calculating model prediction in a unified way.
}
\examples{
library(survival)
library(survex)


cph <- coxph(Surv(time, status) ~ ., data = veteran, model = TRUE, x = TRUE, y = TRUE)
rsf_ranger <- ranger::ranger(Surv(time, status) ~ .,
    data = veteran,
    respect.unordered.factors = TRUE,
    num.trees = 100,
    mtry = 3,
    max.depth = 5
)

cph_exp <- explain(cph)

rsf_ranger_exp <- explain(rsf_ranger,
    data = veteran[, -c(3, 4)],
    y = Surv(veteran$time, veteran$status)
)


predict(cph_exp, veteran[1, ], output_type = "survival")[, 1:10]

predict(cph_exp, veteran[1, ], output_type = "risk")

predict(rsf_ranger_exp, veteran[1, ], output_type = "chf")[, 1:10]

}
