% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmst2adapt.R
\name{rmst2adapt}
\alias{rmst2adapt}
\title{Restricted Mean Survival Times with Adaptively Selected Truncation Time Point}
\usage{
rmst2adapt(indata, tau_star, method="perturbation", nmethod=100000,
        seed=NULL, test="2_side", conf.int=0.95)
}
\arguments{
\item{indata}{A data matrix (data frame). The 1st column is the time-to-event variable, the 2nd column is the event indicator (1=event, 0=censor), and the 3rd column is the treatment indicator (1=treatment, 0=control).
No missing values are allowed in this data matrix.}

\item{tau_star}{A vector indicating a set of tau's. All elements in \code{tau_star} need to be shorter than or equal to the minimum time point of the largest observed time in each of the two groups.}

\item{method}{A type of the resampling method. It supports \code{"perturbation"} (default).}

\item{nmethod}{A number of iterations for resampling. It is recommended to specify at least 100000 (default) or larger.}

\item{seed}{An integer value used for random number generation in the resampling procedures. Default is \code{NULL}.}

\item{test}{Specify \code{"1_side"} for the one-sided test where the alternative hypothesis is that the treatment group is superior to the control group with respect to survival time.
Specify \code{"2_side"} for the two-sided test where the alternative hypothesis is that the treatment group is not equal to the control group with respect to survival time.
Default is \code{"2_side"}.}

\item{conf.int}{Specify a confidence coefficient for calculating confidence bands for the differences in RMST. Default is \code{0.95}.}
}
\value{
an object of class rmst2adapt.

\item{method}{The resampling method used in the analyses}

\item{nmethod}{The number of iterations for the resampling}

\item{test}{The type of test used in the analyses}

\item{candidate_taus}{The set of taus used in the analyses}

\item{observed_z}{The observed test statistic Z_star}

\item{p_value}{The p-value of testing for equality of the RMSTs between the two groups}

\item{conf_band}{The difference in RMST between the two groups at the specified taus}

\item{selected_tau}{The value of tau selected to summarize the treatment effect}
}
\description{
This function performs the procedure proposed by Horiguchi et al. (2018) <doi:10.1002/sim.7661>.
The method specifies a set of truncation time points, taus, for calculating restricted mean survival times (RMST),
performs testing for equality of the RMSTs between the two groups, and estimates the difference in RMST between the two groups at the specified tau's.
The multiplicity as a result of specifying several taus is taken into account in this procedure.
}
\examples{
#--- sample data ---#
data    = rmst2adapt.sample.data()
nmethod = 100 #This is only for example use.
              #Recommended to specify at least 100000 (default) or larger.

a = rmst2adapt(indata=data, tau_star=seq(6,12,2), method="perturbation",
               nmethod=nmethod, test="2_side", seed=123)
print(a)
}
\references{
Horiguchi M, Cronin A, Takeuchi M, Uno H. A flexible and coherent test/estimation procedure based on restricted mean survival times for censored time-to-event data
in randomized clinical trials. Statistics in Medicine 2018. doi:10.1002/sim.7661.
}
\author{
Miki Horiguchi, Hajime Uno
}
