\name{pairwiseHR}
\alias{pairwiseHR}
\title{Computation of log hazard ratio estimate and its standard error estimate from dichotomized dataset}
\usage{
pairwiseHR(treat, studlab, event, n, data)
}
\arguments{
\item{treat}{The treatments of individual arms.}
\item{studlab}{ID variable of studies.}
\item{event}{The number of events of individual arms.}
\item{n}{The number of sample size of individual arms.}
\item{data}{The dataset object.}
}
\value{
\itemize{
\item \code{studlab}: ID variable of studies.
\item \code{treat1}: The treatment of arm 1.
\item \code{treat2}: The treatment of arm 2.
\item \code{TE}: The log hazard ratio estimate.
\item \code{seTE}: Standard error estimate for the log hazard ratio.
\item \code{n1}: The sample size of arm 1.
\item \code{n2}: The sample size of arm 2.
}
}
\description{
Log hazard ratio estimate and its standard error estimate are calculated from dichotomized dataset simultaneously.
}

\references{
Noma, H. and Maruo, K. (2025). Network meta-analysis combining survival and count outcome data: A simple frequentist approach. medRxiv: 10.1101/2025.01.23.25321051.

Salika, T., Turner, R. M., Fisher, D., Tierney, J. F. and White, I. R. (2022). Implications of analysing time-to-event outcomes as binary in meta-analysis: empirical evidence from the Cochrane Database of Systematic Reviews. \emph{BMC Medical Research Methodology} \strong{22}, 73.
}

\examples{
data(woods2)

pairwiseHR(treat, studlab=study, event=d, n, data=woods2)
}
