% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossfit_oracle_preds.R
\name{crossfit_oracle_preds}
\alias{crossfit_oracle_preds}
\title{Generate cross-fitted oracle prediction function estimates}
\usage{
crossfit_oracle_preds(
  time,
  event,
  X,
  folds,
  nuisance_preds,
  pred_generator,
  ...
)
}
\arguments{
\item{time}{\code{n x 1} numeric vector of observed
follow-up times. If there is censoring, these are the minimum of the
event and censoring times.}

\item{event}{\code{n x 1} numeric vector of status indicators of
whether an event was observed.}

\item{X}{\code{n x p} data.frame of observed covariate values}

\item{folds}{\code{n x 1} numeric vector of folds identifiers for cross-fitting}

\item{nuisance_preds}{Named list of conditional event and censoring survival functions
that will be used to estimate the oracle prediction function.}

\item{pred_generator}{Function to be used to estimate oracle prediction function.}

\item{...}{Additional arguments to be passed to \code{pred_generator}.}
}
\value{
Named list of cross-fitted oracle prediction estimates
}
\description{
Generate cross-fitted oracle prediction function estimates
}
