% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baseline.R
\name{baseline}
\alias{baseline}
\title{calculating baseline hazard and baseline cumulative hazard using the result from a \code{coxtv} or \code{coxtp} object}
\usage{
baseline(fit)
}
\arguments{
\item{fit}{model from \code{coxtv} or \code{coxtp}.}
}
\value{
A list with three components:
\item{time}{the unique observed failure times.}
\item{hazard}{the baseline hazard corresponding to each unique failure time point.}
\item{cumulHaz}{the cumulative baseline hazard corresponding to each unique failure time point.}
}
\description{
The baseline estimation is the baseline hazard at each observed failure time when
holding all the covariates to be zero.
}
\examples{
data(ExampleData)
z <- ExampleData$z
time  <- ExampleData$time
event <- ExampleData$event

fit   <- coxtv(event = event, z = z, time = time)
base.est <- baseline(fit)


}
