% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue.R
\name{glue}
\alias{glue}
\alias{glut}
\title{Format and interpolate a string}
\usage{
glue(x, env = parent.frame())

glut(x, env = parent.frame())
}
\arguments{
\item{x}{\verb{[character string]}}

\item{env}{\verb{[environment]}

Where to look up the embraced input.

Can be an environment or a list-like object that will be converted in the
underlying function via \code{list2env()}.}
}
\value{
A \code{character} object.
}
\description{
Inputs enclosed by braces (e.g. \code{{name}}) are looked up in the provided
environment (akin to calling \code{\link[=get]{get()}}). Single braces can be escaped by
doubling them up. Variables are recycled to the length of the largest one.

\code{glue()} operates on the string as is.

\code{glut()} will \code{\link[=trim]{trim}} the input prior to glueing.
}
\examples{
name <- "Fred"
age <- 50
cat(glue("My name is {name} and my age next year is {age}"))

# glut first trims the output
anniversary <- as.Date("1991-10-12")
cat(glut("
    My name is {name},
    my age next year is {age},
    my anniversary is {anniversary}.
"))

# single braces can be inserted by doubling them
glue("My name is {name}, not {{name}}.")

# List like objects can be used in place of an environment
dat <- cbind(car = rownames(mtcars), mtcars)
glue("{car} does {mpg} mpg.", dat)

}
\seealso{
\code{\link[glue:glue_safe]{glue::glue_safe()}} and \code{\link[glue:glue_safe]{glue::glue_data_safe()}} on which which this
function is an evolution.
}
