% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_text.R
\name{tidy_text}
\alias{tidy_text}
\title{Tidy and Split Narrative Text}
\usage{
tidy_text(narratives, split_in_sentences = TRUE)
}
\arguments{
\item{narratives}{A data frame or data.table containing the narratives to be processed. The dataset should include columns representing different types of comments (e.g., \code{sterk}, \code{verbeter}, \code{feedback}).}

\item{split_in_sentences}{A logical value indicating whether to split the text into individual sentences. If \code{TRUE}, the function will split the narratives into sentences using regular expressions. If \code{FALSE}, it will only subset the data based on comment types.}
}
\value{
A data.table containing sentences (or narrative data) with the following columns:
\itemize{
\item \code{document}: The document ID.
\item \code{submissionid}: The submission ID.
\item \code{competencyid}: The competency ID.
\item \code{assistant}: The assistant information.
\item \code{portfolioid}: The portfolio ID.
\item \code{sentenceid}: A unique identifier for each sentence (or narrative entry).
\item \code{sentence}: The cleaned-up sentence text.
}
}
\description{
This function processes narrative data by splitting the text into sentences or simply subsetting the data based on specific comment types. It ensures consistency across various comment types and removes unwanted columns and duplicates.
}
\details{
The \code{tidy_text} function processes a dataset of narratives, splitting them into individual sentences (if \code{split_in_sentences = TRUE}) or subsetting them based on comment types (if \code{split_in_sentences = FALSE}). The comment types are predefined as \code{sterk}, \code{verbeter}, and \code{feedback}.
\itemize{
\item When \code{split_in_sentences = TRUE}, the function unnests the narrative data into sentences using regular expressions to identify sentence boundaries (periods, question marks, and exclamation marks).
\item When \code{split_in_sentences = FALSE}, the function subsets the data by comment type and ensures that the relevant columns are kept.
The function also performs text cleaning by squishing spaces and removing HTML tags.
}
}
