% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_tbl.R
\name{mean_tbl}
\alias{mean_tbl}
\title{Summarize continuous variables}
\usage{
mean_tbl(
  data,
  var_stem,
  escape_stem = FALSE,
  ignore_stem_case = FALSE,
  na_removal = "listwise",
  only = NULL,
  var_labels = NULL,
  ignore = NULL
)
}
\arguments{
\item{data}{A data frame.}

\item{var_stem}{A character string of a variable stem or the full name of a variable in
\code{data}.}

\item{escape_stem}{A logical value indicating whether to escape \code{var_stem}. Default is
\code{FALSE}.}

\item{ignore_stem_case}{A logical value indicating whether the search for columns
matching the supplied \code{var_stem} is case-insensitive. Default is \code{FALSE}.}

\item{na_removal}{A character string specifying how to remove missing values. Should be
one of \code{pairwise} or \code{listwise}. Default is \code{listwise}.}

\item{only}{A character string or vector of character strings of the kinds of summary
statistics to return. Default is \code{NULL}, which returns mean (mean), standard
deviation (sd), minimum value (min), maximum value (max), and non-missing responses
(nobs).}

\item{var_labels}{An optional named character vector or list where each element maps
labels to variable names. If any element is unnamed or if any labels do not match
variables in returned from \code{data}, all labels will be ignored and the table will be
printed without them.}

\item{ignore}{An optional vector that contains values to exclude from the data. Default
is \code{NULL}, which includes all present values.}
}
\value{
A tibble presenting summary statistics for series of continuous variables with
the same variable stem.
}
\description{
\code{mean_tbl()} presents descriptive statistics (mean, sd, minimum, maximum,
number of non-missing observations) for interval (e.g., Test scores) and ratio level
(e.g., Age) variables with the same variable stem. A variable stem is a common prefix
found in related variable names, often corresponding to similar survey items, that
represents a shared concept before unique identifiers (like timep oints) are added. For
example, in the \code{stem_social_psych} dataset, the two variables 'belong_belongStem_w1'
and 'belong_belongStem_w2' share the variable stem 'belong_belongStem' (e.g., "I feel
like an outsider in STEM"), with suffixes (_w1, _w2) indicating different measurement
waves. By default, missing data are excluded from the calculations in a listwise
fashion.
}
\examples{

mean_tbl(data = social_psy_data,
         var_stem = "belong")

mean_tbl(data = social_psy_data,
         var_stem = "belong",
         na_removal = "pairwise",
         var_labels = c(belong_1 = "I feel like I belong at this institution",
                        belong_2 = "I feel like part of the community",
                        belong_3 = "I feel valued by this institution"))

}
\author{
Ama Nyame-Mensah
}
