% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simData.R
\name{simData}
\alias{simData}
\title{Simulating Matrix of Statistics}
\usage{
simData(prop, m, B = 200, rho = 0, n = 50, alpha = 0.05, pw = 0.8, p = TRUE, seed = NULL)
}
\arguments{
\item{prop}{proportion of non-null hypotheses.}

\item{m}{total number of variables.}

\item{B}{number of permutations, including the identity.}

\item{rho}{level of equicorrelation between pairs of variables.}

\item{n}{number of observations.}

\item{alpha}{significance level.}

\item{pw}{power of the t test.}

\item{p}{logical, \code{TRUE} to compute p-values, \code{FALSE} to compute t-scores.}

\item{seed}{seed.}
}
\value{
\code{simData} returns a matrix where the \code{B} rows correspond to permutations (the first is the identity),
and the \code{m} columns correspond to variables.
The matrix contains p-values if \code{p} is \code{TRUE}, and t-scores otherwise.
The first columns (a proportion \code{prop}) correspond to non-null hypotheses.
}
\description{
This function simulates a matrix of permutation statistics,
by performing a t test on normal data.
}
\details{
The function applies the one-sample two-sided t test to a matrix of simulated data,
for \code{B} data permutations.
Data is obtained by simulating \code{n} independent observations from a multivariate normal distribution,
where a proportion \code{prop} of the variables has non-null mean.
This mean is such that the one-sample t test with significance level \code{alpha} has power equal to \code{pw}.
Each pair of distinct variables has equicorrelation \code{rho}.
}
\examples{
# generate matrix of p-values for 5 variables and 10 permutations
G <- simData(prop = 0.6, m = 5, B = 10, alpha = 0.4, seed = 42)

# subset of interest (variables 1 and 2)
S <- c(1,2)
 
# create object of class sumObj
# combination: harmonic mean (Vovk and Wang with r = -1)
res <- sumPvals(G, S, alpha = 0.4, r = -1)
res
summary(res)

# lower confidence bound for the number of true discoveries in S
discoveries(res)

# lower confidence bound for the true discovery proportion in S
tdp(res)

# upper confidence bound for the false discovery proportion in S
fdp(res)
}
\seealso{
True discovery guarantee: \code{\link{sumStats}}, \code{\link{sumPvals}}
}
\author{
Anna Vesely.
}
