% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_glyph_ribbon.R
\name{geom_glyph_ribbon}
\alias{geom_glyph_ribbon}
\title{Create a Glyph Ribbon plot using ggplot2}
\usage{
geom_glyph_ribbon(
  mapping = NULL,
  data = NULL,
  show.legend = NA,
  stat = "identity",
  position = "identity",
  x_major = NULL,
  y_major = NULL,
  x_minor = NULL,
  ymin_minor = NULL,
  ymax_minor = NULL,
  height = "default",
  width = "default",
  x_scale = identity,
  y_scale = identity,
  global_rescale = TRUE,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{x_major, y_major, x_minor, ymin_minor, ymax_minor}{Each combination of
`x_major` and `y_major` forms a unique grid cell. `ymin_minor` and `ymax_minor` define
the lower and upper bounds of the geom_ribbon.}

\item{height}{The height of each glyph. The `default` is calculated using the ratio (1:1.618)
relative to the `width`, to maintain a consistent aspect ratio.}

\item{width}{The width of each glyph. The `default` is set
to the smallest distance between two consecutive coordinates, converted from meters
to degrees of latitude using the Haversine method.}

\item{x_scale, y_scale}{The scaling function applied to each set of minor
values within a grid cell. Defaults to `identity`.}

\item{global_rescale}{A setting that determines whether to perform rescaling globally or on individual glyphs.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Additional arguments passed on to function.}
}
\value{
A ggplot object.
}
\description{
This function creates a ribbon geometry designed to display glyphs based on
the combination of `x_major` and `y_major`. For each `x_minor` value,
`geom_glyph_ribbon()` displays a y interval defined by `ymin_minor` and `ymax_minor`.
}
\examples{

library(ggplot2)

# Basic glyph map with base map and custom theme
aus_temp |>
  ggplot(aes(x_major = long, y_major = lat,
         x_minor = month, ymin_minor = tmin, ymax_minor = tmax)) +
  geom_sf(data = ozmaps::abs_ste, fill = "grey95",
          color = "white",inherit.aes = FALSE) +
  geom_glyph_ribbon() +
  ggthemes::theme_map()


# Adjust width and height of the glyph
aus_temp |>
  ggplot(aes(x_major = long, y_major = lat,
         x_minor = month, ymin_minor = tmin, ymax_minor = tmax)) +
  geom_sf(data = ozmaps::abs_ste, fill = "grey95",
          color = "white",inherit.aes = FALSE) +
  geom_glyph_ribbon(width = rel(4.5), height = rel(3)) +
 ggthemes::theme_map()

# Extend glyph map with reference box and line
aus_temp |>
 ggplot(aes(x_major = long, y_major = lat,
         x_minor = month, ymin_minor = tmin, ymax_minor = tmax)) +
  geom_sf(data = ozmaps::abs_ste, fill = "grey95",
          color = "white",inherit.aes = FALSE) +
  add_glyph_boxes() +
  add_ref_lines() +
  geom_glyph_ribbon() +
  ggthemes::theme_map()
}
