% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stylest2_select_vocab.R
\name{stylest2_terms}
\alias{stylest2_terms}
\title{Select terms above frequency cutoff}
\usage{
stylest2_terms(dfm, cutoff)
}
\arguments{
\item{dfm}{a quanteda \code{dfm} object.}

\item{cutoff}{a single numeric value - the quantile of term frequency under which
to drop terms.}
}
\value{
A character vector of terms falling above the term frequency cutoff.
}
\description{
A function to select terms for inclusion in a stylest2 model, based on a document-feature
matrix of texts to predict and a specified cutoff.
}
\examples{
data(novels_dfm)
best_cut <- stylest2_select_vocab(dfm=novels_dfm)
stylest2_terms(dfm = novels_dfm, cutoff=best_cut$cutoff_pct_best)

}
