% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stylest2_fit.R
\name{stylest2_fit}
\alias{stylest2_fit}
\title{Fit speaker model to document-feature matrix}
\usage{
stylest2_fit(
  dfm,
  smoothing = 0.5,
  terms = NULL,
  term_weights = NULL,
  fill_weight = NULL
)
}
\arguments{
\item{dfm}{a quanteda \code{dfm} object}

\item{smoothing}{the smoothing parameter value for smoothing the dfm. Should 
be a numeric scalar, default to 0.5.}

\item{terms}{If not \code{NULL}, terms to be used in the model. If \code{NULL}, 
use all terms.}

\item{term_weights}{Named vector of distances (or any weights) per term in the 
vocab. Names should correspond to the term.}

\item{fill_weight}{Numeric value to fill in as weight for any term which does 
not have a weight specified in \code{term_weights}.}
}
\value{
An S3 object, a model with with each term that occurs in the text, the 
frequency of use for each author, and the frequency of that terms' occurrence 
through the texts.
}
\description{
This function generates a model of speaker/author attribution, given a document-feature
matrix.
}
\examples{
data(novels_dfm)
stylest2_fit(dfm = novels_dfm)

}
