% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SL_tbl_explore.R
\name{vis_NAs}
\alias{vis_NAs}
\title{vis_NAs}
\usage{
vis_NAs(
  tab,
  response,
  main = paste0("Missing values by student (", attr(tab, "table"), ") (blocks: ",
    paste0(attr(tab, "blocks"), collapse = ", "), ")"),
  show_perc_col = FALSE,
  ...
)
}
\arguments{
\item{tab}{A regularised StudentLife tibble (i.e., an object of class
\code{reg_SL_tbl}) as
produced by the function \code{\link[studentlife]{regularise_time}}.}

\item{response}{A character string naming one of the columns
in \code{tab} that is not in \code{attr(tab, "blocks")}. If
missing then this defaults to the first such column name.}

\item{main}{The plot title, passed to \code{\link[ggplot2]{ggtitle}}.}

\item{show_perc_col}{Logical passed to \code{\link[visdat]{vis_miss}}.
TRUE adds in the percentage of missing data in each column into the x axis.}

\item{...}{Arguments passed to \code{\link[visdat]{vis_miss}}.}
}
\value{
A ggplot object.
}
\description{
Produce a visualisation of the number of missing values
among each student in a regularised SL_tbl.
}
\examples{
d <- tempdir()
download_studentlife(location = d, url = "testdata")

tab_PAM <- load_SL_tibble(schema = "EMA", table = "PAM", location = d)

reg_PAM <- regularise_time(
  tab_PAM, blocks = c("day", "epoch"), m = mean(picture_idx, na.rm = TRUE))

vis_NAs(reg_PAM, response = "m")

}
