% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixedobjective.R
\name{fixedobjective}
\alias{fixedobjective}
\title{Generate a fixed objective function for item selection.}
\usage{
fixedobjective(
  criteria = c("rmsea", "srmr", "crel"),
  add = c("chisq", "df", "pvalue"),
  side = NULL,
  scale = 1,
  matrices = NULL,
  fixed = NULL,
  comparisons = NULL,
  ...
)
}
\arguments{
\item{criteria}{A vector of names of criteria included in the objective function. Defaults to \code{c('rmsea', 'srmr', 'crel')}.}

\item{add}{A vector of names of criteria not used in the objective function, but added in order to be included in the log of solutions.}

\item{side}{Which side good values are located at. \code{'top'} means large values are good (e.g. Reliability), \code{'bottom'} means small values are good (e.g. RMSEA), and \code{'middle'} means average values are good (e.g. factor correlations).}

\item{scale}{A numeric scale to use in weighting the objective component. Defaults to 1.}

\item{matrices}{An object of class \code{stuartObjectiveMatrices} to include matrices (e.g. latent correlations) into the objective function.}

\item{fixed}{An object of class \code{stuartFixedObjective} to include already previously defined fixed objectives.}

\item{comparisons}{A vector of names of criteria included in the objective function which are related to model comparisons (e.g. when determining measurement invariance).}

\item{...}{Additional arguments.}
}
\value{
Returns an object of class \code{stuartFixedObjective}
}
\description{
Generate an objective function from default values for use in an item selection using STUART.
}
\seealso{
\code{\link{empiricalobjective}}, \code{\link{extractobjective}}, \code{\link{objectivematrices}}
}
\author{
Martin Schultze
}
