### Roxygen-inzable documentation
#' Data from a scale for Supervisor Support
#' 
#' A scale for supervisor support with 19 items. The scale consists of two subscales: carreer promotion (items 1 through 12) and feedback and goal setting (items 13 through 19).
#' 
#' @format A data frame with 411 observations on 20 variables. The first variable indicates the person ID, the following 19 all stem from the scale for Supervisor Support
#' 
#' @source Janssen, A.B., Schultze, M., & Grötsch, A. (2015). Following the ants: Development of short scales for proactive personality and supervisor support by Ant Colony Optimization. European Journal of Psychological Assessment.
#' 
"sups"

### Roxygen-inzable documentation
#' MTMM fairplayer Intervention Data (2009)
#' 
#' Self- and teacher-reported empathy (8 item scale), relational aggression (5 item scale), and social intelligence (10 item scale) at three different occasions.
#' 
#' @format A data frame with 143 observations on 142 variables. The variable names consist of an initial letter indicating the source (s: self-report, t: teacher-report), two letters indicating the construct (EM: empathy, RA: relational aggression, SI: social intelligence), a number indicating the item number on the scale, and a "t" followed by a number indicating the measurement occasion.
#' 
#' @source Bull, H., Schultze, M., Scheithauer, H. (2009) School-based prevention of bullying and relational aggression: The fairplayer.manual. European Journal of Developmental Science, 3:313-317.
#' @source Schultze, M. (2012). Evaluating What The Crowd Says. A longitudinal structural equation model for exchangeable and structurally different methods for evaluating interventions. Unpublished Diploma Thesis.
#' 
"fairplayer"

### Roxygen-inzable documentation
#' Data from a German Meaning of Work Scale.
#' 
#' Self-reports from a scale construction study for a German Meaning of Work Scale (Feser et al., 2019) with three facets: Self-realization (17 items), belonging (9 items), justification (8 Items). The data additionally include assessments on the Work and Meaning Inventory (Steger et al., 2012), alienation from work (Fischer and Kohr, 2014). 
#' 
#' \itemize{
#'   \item lfdn. Participant ID.
#'   \item self1 - self17. 17 items of the self-realization facet.
#'   \item belong1 - belong9. 9 items of the belonging facet.
#'   \item just1 - just8. 8 items of the justification facet.
#'   \item wami1 - wami10. 10 items of the Work and Meaning Inventory.
#'   \item alien1 - alien10. 10 item of the alienation from work sacle.
#'   \item age. Age in years.
#'   \item sex. Gender with 1 = female, 2 = other, 3 = male.
#'   \item work. Type of employment 1 = employed, 2 = self-employed, 3 = temp-work, 4 = civil servant.
#'   \item wokrhours. Weekly work hours.
#'   \item tenure1. Years at the current place of employment.
#'   \item tenure2. Years of experience in current job.
#'   \item kldb2010. German Classification of Occupations (first code number).
#' }
#' 
#' @format A data frame with 257 observations on 62 variables.
#' 
#' @source Feser, M., Lorenz, T., & Mainz, E. (2019). Meaning of work: A culture based approach towards the construction of a German questionnaire. Poster presented at the 19th Congress of The European Association for Work & Organizational Psychology. Turin, Italy.
#' @source Fischer, A., & Kohr, H. (2014). Entfremdung von der Arbeit. Zusammentstellung Sozialwissenschaftlicher Items Und Skalen, ZIS. https://doi.org/https://doi.org/10.6102/zis8
#' @source Steger, M. F., Dik, B. J., & Duffy, R. D. (2012). Measuring Meaningful Work. Journal of Career Assessment, 20(3), 322–337. https://doi.org/10.1177/1069072711436160
#' 
"sia"
