% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen_asym.R
\name{data_gen_asym}
\alias{data_gen_asym}
\title{Data Generation Asymptotic}
\usage{
data_gen_asym(
  n,
  weight_mat = matrix(rlnorm(10), nrow = 2, ncol = 5),
  y_int = 0,
  resp_sd = 1,
  window = 1e-05,
  ...
)
}
\arguments{
\item{n}{The number of observations for each parameter.}

\item{weight_mat}{The parameter coefficients, where each column represents
the coefficients and is two rows as each additive equation contains two
parameters. Defaulted to be 10 random numbers from the log-normal
distribution. The second row of the matrix needs to be positive.}

\item{y_int}{The y-intercept term of the additive model.}

\item{resp_sd}{The standard deviation of the epsilon term to be added for
noise.}

\item{window}{Used to determine for any given X variable to get you within
distance to capture the asymptotic behavior.}

\item{...}{Additional arguments that are not currently implemented.}
}
\value{
A data.frame object with the n rows and the response variable with
 the number of parameters being equal to the number of columns from the
 weight matrix.
}
\description{
Creates a synthetic data set for an additive asymptotic model. See the details
 section for clarification.
}
\details{
Observations are generated from the following model:
  \deqn{y = \sum_{i = 1}^n -\alpha_ie^{-\beta_i \cdot x_i} + y_{int}}
  Where `n` is the number of parameters to be used, \eqn{\alpha_i}'s
  are the scaling parameter and the \eqn{\beta_i}'s are the weights
  associated with each \eqn{x_i}. With the \eqn{y_{int}} being where it
  crosses the y-axis.
}
\examples{
 # Generates 10 observations
 asym_data <- data_gen_asym(10)
 asym_data
}
